/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.registries;

import com.github.sejoslaw.vanillamagic2.common.spells.summon.logics.EndermiteSummonLogic;
import com.github.sejoslaw.vanillamagic2.common.spells.summon.logics.GuardianSummonLogic;
import com.github.sejoslaw.vanillamagic2.common.spells.summon.logics.HorseSummonLogic;
import com.github.sejoslaw.vanillamagic2.common.spells.summon.logics.PigmanSummonLogic;
import com.github.sejoslaw.vanillamagic2.common.spells.summon.logics.SkeletonSummonLogic;
import com.github.sejoslaw.vanillamagic2.common.spells.summon.logics.SpiderSummonLogic;
import com.github.sejoslaw.vanillamagic2.common.spells.summon.logics.SummonEntityLogic;
import com.github.sejoslaw.vanillamagic2.common.spells.summon.logics.VillagerSummonLogic;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.world.World;

public final class SummonEntityLogicRegistry {
    private static final Set<SummonEntityLogic> LOGICS = new HashSet<SummonEntityLogic>();

    public static void initialize() {
        LOGICS.add(new EndermiteSummonLogic());
        LOGICS.add(new GuardianSummonLogic());
        LOGICS.add(new PigmanSummonLogic());
        LOGICS.add(new SkeletonSummonLogic());
        LOGICS.add(new SpiderSummonLogic());
        LOGICS.add(new HorseSummonLogic());
        LOGICS.add(new VillagerSummonLogic());
    }

    public static Entity getEntity(World world, EntityType<? extends Entity> defaultType) {
        SummonEntityLogic logic = SummonEntityLogicRegistry.find(defaultType);
        return logic != null ? logic.getEntity(world) : defaultType.func_200721_a(world);
    }

    public static Entity getHorse(World world, EntityType<? extends Entity> defaultType) {
        SummonEntityLogic logic = SummonEntityLogicRegistry.find(defaultType);
        return logic != null ? logic.getHorse(world) : null;
    }

    public static double getPercent(EntityType<? extends Entity> defaultType) {
        SummonEntityLogic logic = SummonEntityLogicRegistry.find(defaultType);
        return logic != null ? (double)logic.getPercent() : 0.0;
    }

    private static SummonEntityLogic find(EntityType<? extends Entity> defaultType) {
        return LOGICS.stream().filter(logic -> logic.entityType == defaultType).findFirst().orElse(null);
    }
}

