/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.tileentities;

import com.github.sejoslaw.vanillamagic2.common.files.VMForgeConfig;
import com.github.sejoslaw.vanillamagic2.common.registries.ItemRegistry;
import com.github.sejoslaw.vanillamagic2.common.registries.TileEntityRegistry;
import com.github.sejoslaw.vanillamagic2.common.tileentities.VMTileEntity;
import com.github.sejoslaw.vanillamagic2.common.utils.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class VMTileAccelerant
extends VMTileEntity {
    private final int ticks;
    private final List<BlockPos> tickPoses = new ArrayList<BlockPos>();
    private BlockPos invPos;

    public VMTileAccelerant() {
        super((TileEntityType<? extends VMTileEntity>)((TileEntityType)TileEntityRegistry.ACCELERANT.get()));
        this.ticks = (Integer)VMForgeConfig.TILE_ACCELERANT_TICKS.get();
    }

    @Override
    public void initialize(World world, BlockPos pos) {
        super.initialize(world, pos);
        this.invPos = this.func_174877_v().func_177972_a(Direction.UP);
        int size = (Integer)VMForgeConfig.TILE_ACCELERANT_SIZE.get();
        for (int x = this.func_174877_v().func_177958_n() - size; x <= this.func_174877_v().func_177958_n() + size; ++x) {
            for (int y = this.func_174877_v().func_177956_o() - size; y <= this.func_174877_v().func_177956_o() + size; ++y) {
                for (int z = this.func_174877_v().func_177952_p() - size; z <= this.func_174877_v().func_177952_p() + size; ++z) {
                    this.tickPoses.add(new BlockPos(x, y, z));
                }
            }
        }
    }

    @Override
    public void tickTileEntity() {
        if (!this.hasCrystal()) {
            return;
        }
        for (BlockPos pos : this.tickPoses) {
            WorldUtils.tick(this.func_145831_w(), pos, this.ticks, this.func_145831_w().field_73012_v);
        }
    }

    private boolean hasCrystal() {
        IInventory inv = WorldUtils.getInventory(this.func_145831_w(), this.invPos);
        if (inv == null) {
            return false;
        }
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!ItemRegistry.ACCELERATION_CRYSTAL.isVMItem(stack)) continue;
            return true;
        }
        return false;
    }
}

