/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.tileentities;

import com.github.sejoslaw.vanillamagic2.common.registries.TileEntityRegistry;
import com.github.sejoslaw.vanillamagic2.common.tileentities.VMTileEntity;
import com.github.sejoslaw.vanillamagic2.common.utils.BlockUtils;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.registries.ForgeRegistries;

public class VMTileLiquidSuppressor
extends VMTileEntity {
    private int ticksRemaining;
    private int blockStateId;

    public VMTileLiquidSuppressor() {
        super((TileEntityType<? extends VMTileEntity>)((TileEntityType)TileEntityRegistry.LIQUID_SUPPRESSOR.get()));
    }

    public void initialize(BlockState state, int duration) {
        this.blockStateId = Block.func_196246_j((BlockState)state);
        this.resetDuration(duration);
    }

    @Override
    public void tickTileEntity() {
        --this.ticksRemaining;
        if (this.ticksRemaining <= 0) {
            this.spawnContainedBlock();
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT nbt = super.func_189515_b(compound);
        nbt.func_74768_a("NBT_TICKS", this.ticksRemaining);
        nbt.func_74768_a("NBT_BLOCK_STATE", this.blockStateId);
        return nbt;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.ticksRemaining = compound.func_74762_e("NBT_TICKS");
        this.blockStateId = compound.func_74762_e("NBT_BLOCK_STATE");
    }

    public void resetDuration(int refresh) {
        this.ticksRemaining = refresh;
    }

    private void spawnContainedBlock() {
        this.func_145843_s();
        this.func_145831_w().func_175656_a(this.func_174877_v(), Block.func_196257_b((int)this.blockStateId));
    }

    public static Block[] getValidBlocks() {
        List<Block> blocks = ForgeRegistries.FLUIDS.getValues().stream().map(fluid -> fluid.func_207188_f().func_206883_i().func_177230_c()).collect(Collectors.toList());
        return BlockUtils.getValidBlocks(blocks);
    }
}

