/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.tileentities.machines.modules;

import com.github.sejoslaw.vanillamagic2.common.files.VMForgeConfig;
import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.IVMTileMachine;
import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.modules.AbstractLogicModule;
import com.github.sejoslaw.vanillamagic2.common.utils.BlockUtils;
import com.github.sejoslaw.vanillamagic2.common.utils.WorldUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class QuarryLogicModule
extends AbstractLogicModule {
    private static final String NBT_MODULE_QUARRY_START_POS_DIRECTION_ID = "NBT_MODULE_QUARRY_START_POS_DIRECTION_ID";
    private static final String NBT_MODULE_QUARRY_DIAMOND_POS = "NBT_MODULE_QUARRY_DIAMOND_POS";
    private static final String NBT_MODULE_QUARRY_REDSTONE_POS = "NBT_MODULE_QUARRY_REDSTONE_POS";

    @Override
    public void setup(IVMTileMachine machine) {
        BlockPos machinePos = machine.getPos();
        Direction diamondDir = Direction.UP;
        BlockPos diamondPos = BlockPos.field_177992_a;
        for (Direction face : Direction.Plane.HORIZONTAL) {
            diamondPos = machinePos.func_177972_a(face);
            if (machine.getWorld().func_180495_p(diamondPos).func_177230_c() != Blocks.field_150484_ah) continue;
            diamondDir = face;
            break;
        }
        this.setPos(machine, diamondPos, NBT_MODULE_QUARRY_DIAMOND_POS);
        this.setPos(machine, machinePos.func_177972_a(diamondDir.func_176735_f()), NBT_MODULE_QUARRY_REDSTONE_POS);
        this.setInt(machine, diamondDir.func_176746_e().func_176745_a(), NBT_MODULE_QUARRY_START_POS_DIRECTION_ID);
        this.setOutputStoragePos(machine, machinePos.func_177972_a(diamondDir.func_176734_d()));
        this.setInputStoragePos(machine, machinePos.func_177972_a(Direction.UP));
        this.setEnergySourcePos(machine, machinePos.func_177972_a(Direction.UP));
        this.setStartPos(machine, machinePos.func_177972_a(diamondDir.func_176746_e()));
        this.setWorkingPos(machine, machinePos.func_177972_a(diamondDir.func_176746_e()));
    }

    @Override
    protected boolean checkStructure(IVMTileMachine machine) {
        return this.hasKey(machine, NBT_MODULE_QUARRY_START_POS_DIRECTION_ID);
    }

    @Override
    protected void work(IVMTileMachine machine) {
        int quarrySize = this.countBlocks(machine, this.getDirection(machine, NBT_MODULE_QUARRY_START_POS_DIRECTION_ID).func_176735_f(), Blocks.field_150484_ah) * (Integer)VMForgeConfig.QUARRY_SIZE.get();
        for (int i = 0; i < this.countBlocks(machine, this.getDirection(machine, NBT_MODULE_QUARRY_START_POS_DIRECTION_ID).func_176734_d(), Blocks.field_150451_bX); ++i) {
            this.performSingleOperation(machine, quarrySize);
        }
    }

    private void performSingleOperation(IVMTileMachine machine, int quarrySize) {
        World world = machine.getWorld();
        BlockPos workingPos = this.getWorkingPos(machine);
        BlockPos startPos = this.getStartPos(machine);
        Direction startPosDir = this.getDirection(machine, NBT_MODULE_QUARRY_START_POS_DIRECTION_ID);
        BlockState mineBlockState = world.func_180495_p(workingPos);
        if (world.func_175623_d(workingPos)) {
            while (world.func_175623_d(workingPos)) {
                workingPos = workingPos.func_177972_a(Direction.DOWN);
            }
        } else if (mineBlockState.func_177230_c() == Blocks.field_150357_h) {
            if (BlockUtils.distanceInLine(workingPos = new BlockPos(workingPos.func_177958_n(), startPos.func_177956_o(), workingPos.func_177952_p()).func_177972_a(startPosDir), startPos) > quarrySize) {
                startPos = startPos.func_177972_a(startPosDir.func_176735_f());
                workingPos = new BlockPos((Vec3i)startPos);
            }
        } else {
            List drops = Block.func_220070_a((BlockState)mineBlockState, (ServerWorld)((ServerWorld)world), (BlockPos)workingPos, (TileEntity)machine.getTileEntity());
            IInventory mineInv = WorldUtils.getInventory(world, workingPos);
            if (mineInv != null) {
                for (int i = 0; i < mineInv.func_70302_i_(); ++i) {
                    ItemStack stack2 = mineInv.func_70301_a(i);
                    if (stack2 == ItemStack.field_190927_a) continue;
                    drops.add(stack2);
                }
            }
            BlockPos outputInvPos = this.getOutputStoragePos(machine);
            IInventory outputInv = WorldUtils.getInventory(world, outputInvPos);
            drops.forEach(stack -> {
                if (outputInv == null) {
                    Block.func_180635_a((World)world, (BlockPos)machine.getPos().func_177967_a(Direction.UP, 2), (ItemStack)stack);
                } else {
                    ItemStack leftStack = HopperTileEntity.func_174918_a(null, (IInventory)outputInv, (ItemStack)stack, (Direction)startPosDir.func_176746_e());
                    if (leftStack != ItemStack.field_190927_a && leftStack.func_190916_E() > 0) {
                        Block.func_180635_a((World)world, (BlockPos)machine.getPos().func_177967_a(Direction.UP, 2), (ItemStack)leftStack);
                    }
                }
            });
            world.func_175656_a(workingPos, Blocks.field_150350_a.func_176223_P());
            workingPos = workingPos.func_177972_a(Direction.DOWN);
        }
        this.setWorkingPos(machine, workingPos);
        this.setStartPos(machine, startPos);
    }

    private int countBlocks(IVMTileMachine machine, Direction dir, Block block) {
        BlockPos machinePos = machine.getPos().func_177972_a(dir);
        int blocksCount = 0;
        while (machine.getWorld().func_180495_p(machinePos).func_177230_c().equals(block)) {
            ++blocksCount;
            machinePos = machinePos.func_177972_a(dir);
        }
        return blocksCount;
    }
}

