/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.utils;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public final class BlockUtils {
    public static void breakBlock(ItemStack stack, World world, PlayerEntity player, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        float strength = block.func_149638_a();
        if (!ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)player, (IBlockReader)world, (BlockPos)pos) || strength > 10.0f) {
            return;
        }
        if (player.func_184812_l_()) {
            block.func_176208_a(world, pos, state, player);
            if (block.removedByPlayer(state, world, pos, player, false, Fluids.field_204541_a.func_207188_f())) {
                block.func_176206_d((IWorld)world, pos, state);
            }
            if (!world.field_72995_K) {
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)world, pos));
            }
            return;
        }
        stack.func_179548_a(world, state, pos, player);
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (block.removedByPlayer(state, world, pos, player, true, Fluids.field_204541_a.func_207188_f())) {
                block.func_176206_d((IWorld)world, pos, state);
                block.func_180657_a(world, player, pos, state, tileEntity, stack);
            }
            ServerPlayerEntity mpPlayer = (ServerPlayerEntity)player;
            mpPlayer.field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)world, pos));
        } else {
            world.func_175669_a(2001, pos, Block.func_196246_j((BlockState)state));
            if (block.removedByPlayer(state, world, pos, player, true, Fluids.field_204541_a.func_207188_f())) {
                block.func_176206_d((IWorld)world, pos, state);
            }
            stack.func_179548_a(world, state, pos, player);
            Minecraft.func_71410_x().func_147114_u().func_147297_a((IPacket)new CPlayerDiggingPacket(CPlayerDiggingPacket.Action.STOP_DESTROY_BLOCK, pos, Direction.func_196054_a((Entity)player)[0]));
        }
    }

    public static int distanceInLine(BlockPos pos1, BlockPos pos2) {
        if (pos1.func_177958_n() == pos2.func_177958_n() && pos1.func_177956_o() == pos2.func_177956_o()) {
            return Math.max(pos1.func_177952_p(), pos2.func_177952_p()) - Math.min(pos1.func_177952_p(), pos2.func_177952_p());
        }
        if (pos1.func_177952_p() == pos2.func_177952_p() && pos1.func_177956_o() == pos2.func_177956_o()) {
            return Math.max(pos1.func_177958_n(), pos2.func_177958_n()) - Math.min(pos1.func_177958_n(), pos2.func_177958_n());
        }
        return Math.max(pos1.func_177956_o(), pos2.func_177956_o()) - Math.min(pos1.func_177956_o(), pos2.func_177956_o());
    }

    public static Block[] getValidBlocks(List<Block> blocks) {
        Block[] blocksArray = new Block[blocks.size()];
        for (int i = 0; i < blocksArray.length; ++i) {
            blocksArray[i] = blocks.get(i);
        }
        return blocksArray;
    }
}

