/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.utils;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public final class EntityUtils {
    public static String getPlayerName(PlayerEntity player) {
        return player.func_200200_C_().func_150254_d();
    }

    public static List<EntityType<?>> getEntitiesByClassification(EntityClassification classification) {
        return ForgeRegistries.ENTITIES.getValues().stream().filter(type -> type.func_220339_d() == classification).collect(Collectors.toList());
    }

    public static void teleport(Entity entity, BlockPos newPos, DimensionType dimensionType) {
        ServerWorld destinationWorld = entity.func_184102_h().func_71218_a(dimensionType);
        EntityUtils.teleport(entity, newPos, (World)destinationWorld);
    }

    public static void teleport(Entity entity, BlockPos newPos, World world) {
        if (entity instanceof ServerPlayerEntity && world instanceof ServerWorld) {
            ((ServerPlayerEntity)entity).func_200619_a((ServerWorld)world, (double)newPos.func_177958_n(), (double)newPos.func_177956_o(), (double)newPos.func_177952_p(), ((ServerPlayerEntity)entity).field_71109_bG, entity.field_70125_A);
        } else {
            if (world != entity.field_70170_p) {
                entity.func_212321_a(world.func_201675_m().func_186058_p());
            }
            entity.func_223102_j((double)newPos.func_177958_n(), (double)newPos.func_177956_o(), (double)newPos.func_177952_p());
        }
    }

    public static Entity getLookingAt(Entity entity) {
        if (Minecraft.func_71410_x().field_71476_x instanceof EntityRayTraceResult) {
            return ((EntityRayTraceResult)Minecraft.func_71410_x().field_71476_x).func_216348_a();
        }
        return null;
    }

    public static void spawnLightningBolt(World world, LightningBoltEntity entity) {
        if (world instanceof ClientWorld) {
            ((ClientWorld)world).func_217410_a(entity);
        } else {
            world.func_217376_c((Entity)entity);
        }
    }
}

