/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.utils;

import com.github.sejoslaw.vanillamagic2.common.tileentities.IVMTileEntity;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public final class WorldUtils {
    public static String WORLD_NAME = "";

    public static List<ItemEntity> getItems(World world, BlockPos pos) {
        AxisAlignedBB aabb = new AxisAlignedBB((double)(pos.func_177958_n() - 1), (double)(pos.func_177956_o() - 1), (double)(pos.func_177952_p() - 1), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1));
        return world.func_175647_a(ItemEntity.class, aabb, Entity::func_70089_S);
    }

    public static List<ItemEntity> getOres(World world, BlockPos pos) {
        return WorldUtils.getItems(world, pos).stream().filter(entity -> entity.func_92059_d().func_77973_b().getRegistryName().toString().toLowerCase().contains("ore")).collect(Collectors.toList());
    }

    public static void spawnOnCauldron(World world, BlockPos pos, List<ItemStack> stacks, Function<ItemStack, Integer> stackCountModifier) {
        BlockPos spawnPos = pos.func_177972_a(Direction.UP);
        stacks.forEach(stack -> {
            stack.func_190920_e(((Integer)stackCountModifier.apply((ItemStack)stack)).intValue());
            Block.func_180635_a((World)world, (BlockPos)spawnPos, (ItemStack)stack);
        });
    }

    public static <TVMTileEntity extends IVMTileEntity> void spawnVMTile(World world, BlockPos pos, TVMTileEntity tile, Consumer<TVMTileEntity> consumer) {
        if (world.field_72995_K || world.field_175730_i.stream().anyMatch(tileEntity -> tileEntity.func_174877_v().equals((Object)pos))) {
            return;
        }
        tile.initialize(world, pos);
        consumer.accept(tile);
        tile.spawn();
    }

    public static void tick(World world, BlockPos pos, int ticks, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        boolean isTickable = tile instanceof ITickableTileEntity;
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        for (int i = 0; i < ticks; ++i) {
            if (isTickable) {
                ((ITickableTileEntity)tile).func_73660_a();
                continue;
            }
            if (!(world instanceof ServerWorld)) continue;
            block.func_225534_a_(state, (ServerWorld)world, pos, rand);
        }
    }

    public static IInventory getInventory(World world, BlockPos pos) {
        return HopperTileEntity.func_195484_a((World)world, (BlockPos)pos);
    }

    public static IVMTileEntity getVMTile(World world, BlockPos pos) {
        return WorldUtils.getVMTiles(world, vmTile -> vmTile.getPos().equals((Object)pos)).stream().findFirst().orElse(null);
    }

    public static List<IVMTileEntity> getVMTiles(World world, Predicate<IVMTileEntity> check) {
        return world.field_175730_i.stream().filter(tile -> tile instanceof IVMTileEntity && check.test((IVMTileEntity)tile)).map(tile -> (IVMTileEntity)tile).collect(Collectors.toList());
    }

    public static String getWorldName(World world) {
        try {
            WORLD_NAME = world.func_72912_H().func_76065_j();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return WORLD_NAME;
    }
}

