/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.core;

import com.github.sejoslaw.vanillamagic2.common.handlers.clients.OpenQuestGuiHandler;
import com.github.sejoslaw.vanillamagic2.common.handlers.clients.OpenVMTileEntityDetailsGuiHandler;
import com.github.sejoslaw.vanillamagic2.common.handlers.clients.RenderingHandler;
import com.github.sejoslaw.vanillamagic2.common.handlers.clients.ShowDeathPointHandler;
import com.github.sejoslaw.vanillamagic2.common.handlers.clients.ShowDurabilityTooltipHandler;
import com.github.sejoslaw.vanillamagic2.common.handlers.clients.ShowHungerTooltipHandler;
import com.github.sejoslaw.vanillamagic2.common.handlers.clients.ShowItemUpgradesTooltipHandler;
import com.github.sejoslaw.vanillamagic2.common.handlers.clients.ShowSaturationTooltipHandler;
import com.github.sejoslaw.vanillamagic2.common.handlers.global.AutoplantHandler;
import com.github.sejoslaw.vanillamagic2.common.handlers.global.VMItemTooltipHandler;
import com.github.sejoslaw.vanillamagic2.common.handlers.servers.ServerCommandsHandler;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

public final class VMEvents {
    public static void initialize() {
        VMEvents.registerGlobalEvents();
        VMEvents.registerListeners();
        if (VMEvents.isClient()) {
            VMEvents.registerClientSpecificEvents();
        } else {
            VMEvents.registerDedicatedServerSpecificEvents();
        }
    }

    public static boolean isClient() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }

    public static void register(Object obj) {
        MinecraftForge.EVENT_BUS.register(obj);
    }

    private static void registerGlobalEvents() {
        VMEvents.register(new AutoplantHandler());
    }

    private static void registerListeners() {
        MinecraftForge.EVENT_BUS.addListener(ServerCommandsHandler::registerCommands);
    }

    private static void registerClientSpecificEvents() {
        VMEvents.register(new OpenQuestGuiHandler());
        VMEvents.register(new OpenVMTileEntityDetailsGuiHandler());
        VMEvents.register(new ShowDeathPointHandler());
        VMEvents.register(new ShowHungerTooltipHandler());
        VMEvents.register(new ShowSaturationTooltipHandler());
        VMEvents.register(new ShowDurabilityTooltipHandler());
        VMEvents.register(new ShowItemUpgradesTooltipHandler());
        VMEvents.register(new VMItemTooltipHandler());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(RenderingHandler::registerEntityRenderers);
    }

    private static void registerDedicatedServerSpecificEvents() {
    }
}

