/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.guis;

import com.github.sejoslaw.vanillamagic2.common.guis.VMGui;
import com.github.sejoslaw.vanillamagic2.common.quests.Quest;
import com.github.sejoslaw.vanillamagic2.common.registries.PlayerQuestProgressRegistry;
import com.github.sejoslaw.vanillamagic2.common.registries.QuestRegistry;
import com.github.sejoslaw.vanillamagic2.common.utils.TextUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class QuestGui
extends VMGui {
    public static final int QUEST_ACHIEVED_COLOR = Color.green.getRGB();
    public static final int QUEST_AVAILABLE_COLOR = Color.yellow.getRGB();
    public static final int QUEST_LOCKED_COLOR = Color.gray.getRGB();
    public final int itemStackIconSize = 18;
    public final int questBackgroundColor = new Color(143, 137, 143).getRGB();
    private QuestTreeNode rootNode;
    private TooltipDrawer tooltipDrawer;
    private double zoom;
    private boolean showQuestNames = true;
    private boolean showAllQuests = false;
    private boolean showQuestTooltip = true;

    public QuestGui() {
        this(TextUtils.translate("vm.gui.questGui.title"));
    }

    protected QuestGui(ITextComponent titleIn) {
        super(titleIn);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.rootNode = QuestTreeNode.parseTree(QuestRegistry.getQuests());
        this.tooltipDrawer = new TooltipDrawer(this);
        this.zoom = 4.0;
        this.addOptionButton("vm.gui.questGui.enableQuestNames", "vm.gui.questGui.disableQuestNames", "vm.gui.questGui.disableQuestNames", () -> this.showQuestNames, button -> {
            this.showQuestNames = !this.showQuestNames;
        });
        this.addOptionButton("vm.gui.questGui.showAllQuests", "vm.gui.questGui.hideLockedQuests", "vm.gui.questGui.showAllQuests", () -> this.showAllQuests, button -> {
            this.showAllQuests = !this.showAllQuests;
        });
        this.addOptionButton("vm.gui.questGui.enableQuestTooltip", "vm.gui.questGui.disableQuestTooltip", "vm.gui.questGui.disableQuestTooltip", () -> this.showQuestTooltip, button -> {
            this.showQuestTooltip = !this.showQuestTooltip;
        });
    }

    public void func_231164_f_() {
        this.rootNode.clear();
    }

    public void scroll(double scroll) {
        this.zoom += scroll > 0.0 ? 1.0 : -1.0;
    }

    @Override
    protected void renderInnerGui(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        matrixStack.func_227860_a_();
        this.move(matrixStack, this.centerX, this.centerY, 0.0f);
        this.drawQuestTreeNode(matrixStack, this.rootNode, mouseX, mouseY);
        matrixStack.func_227865_b_();
        if (this.showQuestTooltip) {
            matrixStack.func_227860_a_();
            this.tooltipDrawer.draw(matrixStack, mouseX, mouseY);
            matrixStack.func_227865_b_();
        } else {
            this.tooltipDrawer.setup(null);
        }
    }

    public void drawQuestTreeNode(MatrixStack matrixStack, QuestTreeNode node, int mouseX, int mouseY) {
        this.drawQuest(matrixStack, node);
        this.checkTooltip(node, mouseX, mouseY);
        node.children.forEach(childNode -> {
            if (childNode.color == QUEST_LOCKED_COLOR && !this.showAllQuests) {
                return;
            }
            int offsetX = this.getOffsetX((QuestTreeNode)childNode);
            int offsetY = this.getOffsetY((QuestTreeNode)childNode);
            this.drawConnection(matrixStack, (QuestTreeNode)childNode, offsetX, offsetY);
            this.drawQuestTreeNode(matrixStack, (QuestTreeNode)childNode, mouseX, mouseY);
            this.moveBackToParent(matrixStack, offsetX, offsetY);
        });
    }

    public void checkTooltip(QuestTreeNode node, int mouseX, int mouseY) {
        boolean predicate;
        int startCenterX = this.field_230708_k_ / 2;
        int startCenterY = this.field_230709_l_ / 2;
        int radius = this.itemStackIconSize / 2;
        int deltaX = this.centerX - startCenterX;
        int deltaY = this.centerY - startCenterY;
        int questPosX = this.getTotalOffsetX(node);
        int questPosY = this.getTotalOffsetY(node);
        int movedMousePosX = mouseX - deltaX - startCenterX;
        int movedMousePosY = mouseY - deltaY - startCenterY;
        boolean bl = predicate = movedMousePosX + radius > questPosX && movedMousePosX - radius < questPosX && movedMousePosY + radius > questPosY && movedMousePosY - radius < questPosY;
        if (predicate) {
            this.tooltipDrawer.setup(node);
        }
    }

    public void moveBackToParent(MatrixStack matrixStack, int offsetX, int offsetY) {
        this.move(matrixStack, -offsetX, -offsetY, 0.0f);
        boolean straightY = true;
        if (offsetX != 0) {
            this.move(matrixStack, offsetX > 0 ? -(this.itemStackIconSize / 2) - 1 : this.itemStackIconSize / 2 + 1, 0.0f, 0.0f);
            straightY = false;
        }
        if (offsetY != 0 && straightY) {
            this.move(matrixStack, 0.0f, offsetY > 0 ? -(this.itemStackIconSize / 2) : this.itemStackIconSize / 2, 0.0f);
        }
    }

    public void drawConnection(MatrixStack matrixStack, QuestTreeNode child, int offsetX, int offsetY) {
        boolean straightY = true;
        if (offsetX != 0) {
            this.move(matrixStack, offsetX > 0 ? this.itemStackIconSize / 2 + 1 : -(this.itemStackIconSize / 2) - 1, 0.0f, 0.0f);
            this.func_238465_a_(matrixStack, 0, offsetX, 0, child.color);
            this.move(matrixStack, offsetX, 0.0f, 0.0f);
            straightY = false;
        }
        if (offsetY != 0) {
            if (straightY) {
                this.move(matrixStack, 0.0f, offsetY > 0 ? this.itemStackIconSize / 2 : -(this.itemStackIconSize / 2), 0.0f);
            }
            this.func_238473_b_(matrixStack, 0, offsetY, 0, child.color);
            this.move(matrixStack, 0.0f, offsetY, 0.0f);
        }
    }

    public int getOffsetX(QuestTreeNode node) {
        return this.itemStackIconSize * node.quest.posX * (int)this.zoom;
    }

    public int getOffsetY(QuestTreeNode node) {
        return this.itemStackIconSize * node.quest.posY * (int)this.zoom;
    }

    public void drawQuest(MatrixStack matrixStack, QuestTreeNode node) {
        float move = this.itemStackIconSize / 2;
        this.move(matrixStack, -move, -move, 0.0f);
        QuestGui.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)this.itemStackIconSize, (int)this.itemStackIconSize, (int)this.questBackgroundColor);
        this.drawQuestOverlay(matrixStack, node.color);
        this.drawItemStack(node.quest.iconStack, this.getTotalOffsetX(node), this.getTotalOffsetY(node), node.quest.getDisplayName());
        this.move(matrixStack, move, move, 0.0f);
    }

    public void drawQuestOverlay(MatrixStack matrixStack, int color) {
        this.func_238473_b_(matrixStack, 0, this.itemStackIconSize, 0, color);
        this.func_238465_a_(matrixStack, 0, this.itemStackIconSize, 0, color);
        ((Object)((Object)this)).getClass();
        this.move(matrixStack, 18.0f, 0.0f, 0.0f);
        this.func_238473_b_(matrixStack, 0, this.itemStackIconSize, 0, color);
        float f = -this.itemStackIconSize;
        ((Object)((Object)this)).getClass();
        this.move(matrixStack, f, 18.0f, 0.0f);
        this.func_238465_a_(matrixStack, 0, this.itemStackIconSize, 0, color);
        this.move(matrixStack, 0.0f, -this.itemStackIconSize, 0.0f);
    }

    public void drawItemStack(ItemStack stack, int x, int y, String text) {
        x += this.centerX - this.itemStackIconSize / 2 + 1;
        y += this.centerY - this.itemStackIconSize / 2 + 1;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_230712_o_;
        }
        this.field_230707_j_.func_180450_b(stack, x, y);
        this.field_230707_j_.func_180453_a(font, stack, x + font.func_78256_a(text) + 3, y - 18, this.showQuestNames ? text : "");
    }

    public int getTotalOffsetX(QuestTreeNode node) {
        if (node.parentNode == null) {
            return 0;
        }
        int offsetX = this.getOffsetX(node);
        int parentOffsetX = this.getTotalOffsetX(node.parentNode);
        int iconOffsetX = 0;
        if (offsetX != 0) {
            iconOffsetX = offsetX < 0 ? -(this.itemStackIconSize / 2) - 1 : this.itemStackIconSize / 2 + 1;
        }
        return offsetX + parentOffsetX + iconOffsetX;
    }

    public int getTotalOffsetY(QuestTreeNode node) {
        if (node.parentNode == null) {
            return 0;
        }
        int offsetY = this.getOffsetY(node);
        int parentOffsetY = this.getTotalOffsetY(node.parentNode);
        int iconOffsetY = 0;
        if (offsetY != 0) {
            iconOffsetY = offsetY < 0 ? -(this.itemStackIconSize / 2) : this.itemStackIconSize / 2;
        }
        return offsetY + parentOffsetY + iconOffsetY;
    }

    private static class TooltipDrawer {
        private final QuestGui gui;
        private QuestTreeNode node;

        public TooltipDrawer(QuestGui gui) {
            this.gui = gui;
        }

        public void setup(QuestTreeNode node) {
            this.node = node;
        }

        public void draw(MatrixStack matrixStack, int mouseX, int mouseY) {
            if (this.node == null) {
                return;
            }
            this.gui.move(matrixStack, mouseX + 3, mouseY + 8, 0.0f);
            ArrayList<ITextComponent> lines = new ArrayList<ITextComponent>();
            this.node.quest.fillTooltip(lines);
            this.gui.func_243308_b(matrixStack, lines, -(this.gui.itemStackIconSize / 2), 0);
            this.node = null;
        }
    }

    private static class QuestTreeNode {
        public Quest quest;
        public Set<QuestTreeNode> children;
        public int color;
        public QuestTreeNode parentNode;

        public QuestTreeNode(Quest quest, int color, QuestTreeNode parentNode) {
            this.quest = quest;
            this.children = new HashSet<QuestTreeNode>();
            this.color = color;
            this.parentNode = parentNode;
        }

        public void clear() {
            this.quest = null;
            this.children.forEach(QuestTreeNode::clear);
            this.children = null;
            this.color = 0;
        }

        public static QuestTreeNode parseTree(Collection<Quest> quests) {
            Quest rootQuest = quests.stream().filter(quest -> quest.parent == null).findFirst().orElse(new Quest());
            QuestTreeNode rootNode = new QuestTreeNode(rootQuest, QuestTreeNode.getQuestColor(rootQuest), null);
            quests.remove(rootQuest);
            QuestTreeNode.parseTree(rootNode, quests);
            return rootNode;
        }

        private static void parseTree(QuestTreeNode rootNode, Collection<Quest> quests) {
            ArrayList achievedQuests = new ArrayList();
            ArrayList availableQuests = new ArrayList();
            ArrayList lockedQuests = new ArrayList();
            quests.stream().filter(quest -> quest.parent == rootNode.quest).forEach(quest -> {
                int color = QuestTreeNode.getQuestColor(quest);
                if (color == QUEST_ACHIEVED_COLOR) {
                    achievedQuests.add(new QuestTreeNode((Quest)quest, color, rootNode));
                } else if (color == QUEST_AVAILABLE_COLOR) {
                    availableQuests.add(new QuestTreeNode((Quest)quest, color, rootNode));
                } else {
                    lockedQuests.add(new QuestTreeNode((Quest)quest, color, rootNode));
                }
            });
            rootNode.children.addAll(lockedQuests);
            rootNode.children.addAll(availableQuests);
            rootNode.children.addAll(achievedQuests);
            quests.removeAll(achievedQuests.stream().map(node -> node.quest).collect(Collectors.toList()));
            quests.removeAll(availableQuests.stream().map(node -> node.quest).collect(Collectors.toList()));
            quests.removeAll(lockedQuests.stream().map(node -> node.quest).collect(Collectors.toList()));
            rootNode.children.forEach(childNode -> QuestTreeNode.parseTree(childNode, quests));
        }

        private static int getQuestColor(Quest quest) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (PlayerQuestProgressRegistry.hasPlayerGotQuest((PlayerEntity)player, quest.uniqueName)) {
                return QUEST_ACHIEVED_COLOR;
            }
            if (PlayerQuestProgressRegistry.canPlayerGetQuest((PlayerEntity)player, quest.uniqueName)) {
                return QUEST_AVAILABLE_COLOR;
            }
            return QUEST_LOCKED_COLOR;
        }
    }
}

