/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.guis;

import com.github.sejoslaw.vanillamagic2.common.guis.VMGui;
import com.github.sejoslaw.vanillamagic2.common.tileentities.IVMTileEntity;
import com.github.sejoslaw.vanillamagic2.common.utils.NbtUtils;
import com.github.sejoslaw.vanillamagic2.common.utils.TextUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VMTileEntityDetailsGui
extends VMGui {
    private final IVMTileEntity tileEntity;
    private int lineHeight;
    protected boolean showTileNbt = false;

    public VMTileEntityDetailsGui(IVMTileEntity tileEntity) {
        super(TextUtils.translate("vm.gui.vmTileEntityGui.title"));
        this.tileEntity = tileEntity;
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.centerX = this.field_230708_k_ / 3;
        this.centerY = this.field_230709_l_ / 5;
        this.lineHeight = this.field_230712_o_.func_78267_b("vanillamagic2", 100);
        this.addOptionButton("vm.gui.vmTileEntityGui.showNbtData", "vm.gui.vmTileEntityGui.hideNbtData", "vm.gui.vmTileEntityGui.showNbtData", () -> this.showTileNbt, button -> {
            this.showTileNbt = !this.showTileNbt;
        });
    }

    @Override
    protected void renderInnerGui(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        VMTileEntityDetailsGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)TextUtils.buildMessageLine("vm.gui.vmTileEntityGui.name", this.tileEntity.getClass().getSimpleName()), (int)this.centerX, (int)this.centerY, (int)TEXT_COLOR);
        this.nextLine(matrixStack);
        this.renderTileInformation(matrixStack);
        if (this.showTileNbt) {
            this.nextLine(matrixStack);
            this.nextLine(matrixStack);
            this.renderNbtData(matrixStack, mouseX, mouseY);
        }
    }

    private void nextLine(MatrixStack matrixStack) {
        this.move(matrixStack, 0.0f, this.lineHeight, 0.0f);
    }

    private void renderTileInformation(MatrixStack matrixStack) {
        ArrayList<ITextComponent> lines = new ArrayList<ITextComponent>();
        this.tileEntity.addInformation(lines);
        for (ITextComponent line : lines) {
            VMTileEntityDetailsGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)TextUtils.getFormattedText(line), (int)this.centerX, (int)this.centerY, (int)TEXT_COLOR);
            this.nextLine(matrixStack);
        }
    }

    private void renderNbtData(MatrixStack matrixStack, int mouseX, int mouseY) {
        CompoundNBT nbt = this.tileEntity.serializeNBT();
        NbtUtils.forEachEntry((INBT)nbt, (depth, key, value) -> {
            String singleSpace = "    ";
            StringBuilder tab = new StringBuilder();
            for (int i = 0; i < depth; ++i) {
                tab.append("    ");
            }
            String str = tab.toString() + key + ": " + value;
            VMTileEntityDetailsGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)str, (int)this.centerX, (int)this.centerY, (int)TEXT_COLOR);
            this.nextLine(matrixStack);
        });
    }
}

