/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.handlers;

import com.github.sejoslaw.vanillamagic2.common.functions.Action;
import com.github.sejoslaw.vanillamagic2.common.functions.Consumer2;
import com.github.sejoslaw.vanillamagic2.common.functions.Consumer3;
import com.github.sejoslaw.vanillamagic2.common.functions.Consumer4;
import com.github.sejoslaw.vanillamagic2.common.functions.Consumer5;
import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public abstract class EventHandler {
    protected final String squareSymbol = "\u25a0";

    public void onItemExpire(ItemExpireEvent event, Consumer4<ItemEntity, ItemStack, IWorld, BlockPos> consumer) {
        ItemEntity entity = event.getEntityItem();
        consumer.accept(entity, entity.func_92059_d(), (IWorld)entity.func_130014_f_(), entity.func_233580_cy_());
    }

    public void onLivingDeath(LivingDeathEvent event, Consumer2<LivingEntity, DamageSource> consumer) {
        LivingEntity entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        consumer.accept(entity, source);
    }

    public void onShowTooltip(ItemTooltipEvent event, boolean show, Consumer3<PlayerEntity, ItemStack, List<ITextComponent>> consumer) {
        PlayerEntity player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        List tooltips = event.getToolTip();
        if (!show) {
            return;
        }
        consumer.accept(player, stack, tooltips);
    }

    public void withFood(ItemStack stack, Consumer<Food> consumer) {
        if (stack.func_77973_b().func_219971_r()) {
            consumer.accept(stack.func_77973_b().func_219967_s());
        }
    }

    public void withHands(PlayerEntity player, Consumer2<ItemStack, ItemStack> consumer) {
        consumer.accept(player.func_184592_cb(), player.func_184614_ca());
    }

    public void forDamageable(ItemStack stack, Action action) {
        if (stack.func_77984_f()) {
            action.execute();
        }
    }

    public void onRegisterCommand(RegisterCommandsEvent event, Consumer<CommandDispatcher<CommandSource>> consumer) {
        CommandDispatcher dispatcher = event.getDispatcher();
        consumer.accept((CommandDispatcher<CommandSource>)dispatcher);
    }

    public void registerRenderers(FMLClientSetupEvent event, Consumer<Minecraft> consumer) {
        Minecraft mc = (Minecraft)event.getMinecraftSupplier().get();
        consumer.accept(mc);
    }

    public void onPlayerInteract(PlayerInteractEvent event, Consumer4<PlayerEntity, IWorld, BlockPos, Direction> consumer) {
        PlayerEntity player = event.getPlayer();
        World world = player.func_130014_f_();
        BlockPos pos = event.getPos();
        Direction face = event.getFace();
        consumer.accept(player, (IWorld)world, pos, face);
    }

    public void onBlockBreak(BlockEvent.BreakEvent event, Consumer4<PlayerEntity, IWorld, BlockPos, BlockState> consumer) {
        PlayerEntity player = event.getPlayer();
        IWorld world = event.getWorld();
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        consumer.accept(player, world, pos, state);
    }

    public void onBoneMeal(BonemealEvent event, Consumer5<PlayerEntity, IWorld, BlockPos, BlockState, ItemStack> consumer) {
        PlayerEntity player = event.getPlayer();
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        BlockState state = event.getBlock();
        ItemStack stack = event.getStack();
        consumer.accept(player, (IWorld)world, pos, state, stack);
    }

    public void onKeyPressed(InputEvent.KeyInputEvent event, Consumer4<Integer, Integer, Integer, Integer> consumer) {
        consumer.accept(event.getKey(), event.getScanCode(), event.getAction(), event.getModifiers());
    }

    public void onScroll(GuiScreenEvent.MouseScrollEvent.Pre event, Consumer4<Screen, Double, Double, Double> consumer) {
        consumer.accept(event.getGui(), event.getMouseX(), event.getMouseY(), event.getScrollDelta());
    }
}

