/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.itemupgrades.eventcallers;

import com.github.sejoslaw.vanillamagic2.common.functions.Function2;
import com.github.sejoslaw.vanillamagic2.common.itemupgrades.ItemUpgradeEventCaller;
import com.github.sejoslaw.vanillamagic2.common.utils.BlockUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ItemUpgradeEventCallerMining3x3
extends ItemUpgradeEventCaller {
    private static final Map<Direction, Vector3i> DIRECTIONS = new HashMap<Direction, Vector3i>();

    @SubscribeEvent
    public void onMined(BlockEvent.BreakEvent event) {
        this.eventCaller.executor.onBlockBreakNoHandsCheck(event, (player, world, pos, state) -> this.getQuest((PlayerEntity)player), (player, world, pos, state, quest) -> this.execute((PlayerEntity)player, () -> this.eventCaller.executor.withHands((PlayerEntity)player, (leftHandStack, rightHandStack) -> {
            Vector3d lookVec = player.func_70040_Z();
            Direction playerFacing = Direction.func_210769_a((double)lookVec.func_82615_a(), (double)lookVec.func_82617_b(), (double)lookVec.func_82616_c());
            int size = 3;
            ArrayList<BlockPos> minedPoses = new ArrayList<BlockPos>();
            Vector3i cornerVec = DIRECTIONS.get(playerFacing);
            BlockPos cornerPos = pos.func_177982_a(cornerVec.func_177958_n() * (size / 2), cornerVec.func_177956_o() * (size / 2), cornerVec.func_177952_p() * (size / 2));
            if (playerFacing == Direction.DOWN || playerFacing == Direction.UP) {
                this.calculateMinedPoses(size, minedPoses, cornerPos, cornerVec, (col, row) -> col);
            } else {
                this.calculateMinedPoses(size, minedPoses, cornerPos, cornerVec, (col, row) -> row);
            }
            minedPoses.forEach(minedPos -> BlockUtils.breakBlock(rightHandStack, world, player, minedPos));
        })));
    }

    protected void calculateMinedPoses(int size, List<BlockPos> minedPoses, BlockPos cornerPos, Vector3i cornerVec, Function2<Integer, Integer, Integer> getZ) {
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                minedPoses.add(cornerPos.func_177982_a(row * -cornerVec.func_177958_n(), col * -cornerVec.func_177956_o(), getZ.apply(col, row) * -cornerVec.func_177952_p()));
            }
        }
    }

    static {
        DIRECTIONS.put(Direction.SOUTH, Direction.EAST.func_176730_m().func_177979_c(1));
        DIRECTIONS.put(Direction.EAST, Direction.NORTH.func_176730_m().func_177979_c(1));
        DIRECTIONS.put(Direction.NORTH, Direction.WEST.func_176730_m().func_177979_c(1));
        DIRECTIONS.put(Direction.WEST, Direction.SOUTH.func_176730_m().func_177979_c(1));
        DIRECTIONS.put(Direction.UP, Direction.SOUTH.func_176730_m().func_177967_a(Direction.EAST, 1));
        DIRECTIONS.put(Direction.DOWN, Direction.SOUTH.func_176730_m().func_177967_a(Direction.EAST, 1));
    }
}

