/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.json;

import com.github.sejoslaw.vanillamagic2.common.json.IJsonService;
import com.github.sejoslaw.vanillamagic2.common.json.JsonItemStack;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class JsonService
implements IJsonService {
    private final JsonObject json;

    public JsonService(JsonObject json) {
        this.json = json;
    }

    @Override
    public JsonItemStack toItemStack() {
        return new JsonItemStack(this);
    }

    @Override
    public String getString(String key) {
        return this.getValue(key, JsonElement::getAsString, "");
    }

    @Override
    public byte getByte(String key) {
        return this.getValue(key, JsonElement::getAsByte, (byte)0);
    }

    @Override
    public int getInt(String key) {
        return this.getValue(key, JsonElement::getAsInt, 0);
    }

    @Override
    public JsonItemStack getItemStack(String key) {
        JsonObject jsonObjectStack = this.json.getAsJsonObject(key);
        JsonService service = new JsonService(jsonObjectStack);
        return new JsonItemStack(service);
    }

    @Override
    public List<IJsonService> getList(String key) {
        ArrayList<IJsonService> list = new ArrayList<IJsonService>();
        JsonArray jsonArray = this.getValue(key, JsonElement::getAsJsonArray, new JsonArray());
        for (JsonElement jsonElement : jsonArray) {
            list.add(new JsonService(jsonElement.getAsJsonObject()));
        }
        return list;
    }

    @Override
    public Set<String> getEntries() {
        return this.json.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private <T> T getValue(String key, Function<JsonElement, T> desiredOutput, T defaultIfNotFound) {
        JsonElement element = this.json.get(key);
        return element != null ? desiredOutput.apply(element) : defaultIfNotFound;
    }

    public static void parseArray(Reader reader, Consumer<IJsonService> consumer) {
        JsonService.parseInternal(reader, rootElement -> rootElement.getAsJsonArray().forEach(jsonElement -> JsonService.call(jsonElement, consumer)));
    }

    public static void parse(Reader reader, Consumer<IJsonService> consumer) {
        JsonService.parseInternal(reader, rootElement -> JsonService.call(rootElement, consumer));
    }

    public static void writePlayerQuestProgress(Writer writer, Set<String> playerQuests) {
        JsonWriter jsonWriter = new JsonWriter(writer);
        try {
            jsonWriter.beginObject();
            for (String questUniqueName : playerQuests) {
                jsonWriter.name(questUniqueName).value(1L);
            }
            jsonWriter.endObject();
            jsonWriter.flush();
            jsonWriter.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void parseInternal(Reader reader, Consumer<JsonElement> consumer) {
        JsonParser parser = new JsonParser();
        JsonElement rootElement = parser.parse(reader);
        consumer.accept(rootElement);
    }

    private static void call(JsonElement rootElement, Consumer<IJsonService> consumer) {
        if (rootElement == null || rootElement.isJsonNull()) {
            rootElement = new JsonObject();
        }
        JsonService service = new JsonService(rootElement.getAsJsonObject());
        consumer.accept(service);
    }
}

