/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.networks;

import com.github.sejoslaw.vanillamagic2.common.registries.PlayerQuestProgressRegistry;
import com.github.sejoslaw.vanillamagic2.common.utils.EntityUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SSyncQuestsPacket
implements IPacket<IClientPlayNetHandler> {
    private String playerName;
    private Set<String> playerQuests;

    public SSyncQuestsPacket withPlayer(PlayerEntity player) {
        this.playerName = EntityUtils.getPlayerNameFormatted(player);
        this.playerQuests = PlayerQuestProgressRegistry.getPlayerQuests(player);
        return this;
    }

    public void func_148837_a(PacketBuffer buf) throws IOException {
        this.playerName = buf.func_218666_n();
        int questsCount = buf.readInt();
        this.playerQuests = new HashSet<String>();
        for (int i = 0; i < questsCount; ++i) {
            this.playerQuests.add(buf.func_218666_n());
        }
    }

    public void func_148840_b(PacketBuffer buf) throws IOException {
        buf.func_180714_a(this.playerName);
        buf.writeInt(this.playerQuests.size());
        this.playerQuests.forEach(arg_0 -> ((PacketBuffer)buf).func_180714_a(arg_0));
    }

    public void processPacket(IClientPlayNetHandler handler) {
        SSyncQuestsPacket.sync(this);
    }

    public static void encode(SSyncQuestsPacket packet, PacketBuffer buf) {
        try {
            packet.func_148840_b(buf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static SSyncQuestsPacket decode(PacketBuffer buf) {
        SSyncQuestsPacket packet = new SSyncQuestsPacket();
        try {
            packet.func_148837_a(buf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return packet;
    }

    public static void consume(SSyncQuestsPacket packet, Supplier<NetworkEvent.Context> buf) {
        SSyncQuestsPacket.sync(packet);
    }

    private static void sync(SSyncQuestsPacket packet) {
        PlayerQuestProgressRegistry.clearData(packet.playerName);
        PlayerQuestProgressRegistry.setupPlayerData(packet.playerName, packet.playerQuests);
    }
}

