/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.quests.eventcallers;

import com.github.sejoslaw.vanillamagic2.common.quests.EventCaller;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestCaptureEntity;
import com.github.sejoslaw.vanillamagic2.common.utils.TextUtils;
import com.github.sejoslaw.vanillamagic2.common.utils.WorldUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class EventCallerCaptureEntity
extends EventCaller<QuestCaptureEntity> {
    @SubscribeEvent
    public void onEntityCapture(PlayerInteractEvent.EntityInteract event) {
        this.executor.onEntityInteract(event, (player, entity, world, pos) -> WorldUtils.getIsRemote(world) || player.func_184592_cb().func_77973_b() != Items.field_151122_aG ? null : (QuestCaptureEntity)this.quests.get(0), (player, entity, world, pos) -> this.executor.withHands((PlayerEntity)player, (leftHandStack, rightHandStack) -> {
            if (entity instanceof PlayerEntity) {
                return;
            }
            leftHandStack = new ItemStack((IItemProvider)Items.field_151134_bR);
            CompoundNBT stackNbt = leftHandStack.func_196082_o();
            CompoundNBT entityTag = new CompoundNBT();
            entity.func_184198_c(entityTag);
            stackNbt.func_218657_a("NBT_CAPTURED", (INBT)entityTag);
            stackNbt.func_74778_a("NBT_ENTITY_TYPE", entity.func_200600_R().getRegistryName().toString());
            stackNbt.func_74778_a("NBT_ENTITY_NAME", entity.func_200200_C_().getString());
            leftHandStack.func_200302_a(TextUtils.combine(TextUtils.translate("quest.capturedEntity.bookTitlePrefix"), " " + entity.func_200200_C_().getString()));
            entity.func_70106_y();
            player.func_184201_a(EquipmentSlotType.OFFHAND, leftHandStack);
        }));
    }

    @SubscribeEvent
    public void onEntityRelease(PlayerInteractEvent.RightClickBlock event) {
        this.executor.onPlayerInteract((PlayerInteractEvent)event, (player, world, pos, direction) -> player.func_184592_cb().func_196082_o().func_74764_b("NBT_CAPTURED") ? (QuestCaptureEntity)this.quests.get(0) : null, (player, world, pos, direction, quest) -> this.executor.withHands((PlayerEntity)player, (leftHandStack, rightHandStack) -> {
            CompoundNBT stackNbt = leftHandStack.func_196082_o();
            if (!stackNbt.func_74764_b("NBT_CAPTURED") || WorldUtils.getIsRemote(world)) {
                return;
            }
            String type = stackNbt.func_74779_i("NBT_ENTITY_TYPE");
            Entity entity = ((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(type))).func_200721_a(WorldUtils.asWorld(world));
            entity.func_70020_e(stackNbt.func_74775_l("NBT_CAPTURED"));
            BlockPos spawnPos = pos.func_177972_a(direction);
            entity.func_70012_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() + 0.5, (double)spawnPos.func_177952_p() + 0.5, 0.0f, 0.0f);
            world.func_217376_c(entity);
            player.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)Items.field_151122_aG));
        }));
    }
}

