/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.quests.eventcallers;

import com.github.sejoslaw.vanillamagic2.common.quests.EventCaller;
import com.github.sejoslaw.vanillamagic2.common.quests.Quest;
import com.github.sejoslaw.vanillamagic2.common.recipes.AltarRecipe;
import com.github.sejoslaw.vanillamagic2.common.utils.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public abstract class EventCallerCraftable<TQuest extends Quest>
extends EventCaller<TQuest> {
    protected List<AltarRecipe> recipes = new ArrayList<AltarRecipe>();

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (this.quests.size() > 0 && this.recipes.isEmpty()) {
            this.fillRecipes();
        }
        this.executor.craftOnAltar((PlayerInteractEvent)event, this.recipes, this::canCraftOnAltar);
    }

    public boolean canCraftOnAltar(ItemStack requiredIngredientStack, ItemStack ingredientInCauldronStack) {
        return true;
    }

    public abstract void fillRecipes();

    protected <T> void fillCrystalRecipesFromRegistry(Set<Map.Entry<RegistryKey<T>, T>> entries, Function<T, ItemStack> getIngredient, Function<T, ItemStack> getResult, String displayNameKey, Function<Map.Entry<RegistryKey<T>, T>, String> getDisplayName) {
        for (Map.Entry<RegistryKey<T>, T> entry : entries) {
            ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
            ingredients.add(new ItemStack((IItemProvider)Items.field_151156_bN));
            ingredients.add(getIngredient.apply(entry.getValue()));
            ItemStack stack = getResult.apply(entry.getValue());
            stack.func_196082_o().func_74778_a("NBT_VM_ITEM_UNIQUE_NAME", entry.getKey().toString());
            String parsedDisplayName = getDisplayName.apply(entry);
            stack.func_200302_a(TextUtils.combine(TextUtils.translate(displayNameKey), " " + (parsedDisplayName == null ? entry.getKey().toString() : TextUtils.getFormattedText(parsedDisplayName))));
            ArrayList<ItemStack> results = new ArrayList<ItemStack>();
            results.add(stack);
            this.recipes.add(new AltarRecipe((Quest)this.quests.get(0), ingredients, results));
        }
    }
}

