/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.quests.eventcallers;

import com.github.sejoslaw.vanillamagic2.common.quests.EventCaller;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestFullTreeCut;
import com.github.sejoslaw.vanillamagic2.common.utils.BlockUtils;
import com.github.sejoslaw.vanillamagic2.common.utils.WorldUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventCallerFullTreeCut
extends EventCaller<QuestFullTreeCut> {
    @SubscribeEvent
    public void onTreeCut(BlockEvent.BreakEvent event) {
        this.executor.onBlockBreak(event, (player, world, pos, state) -> EventCallerFullTreeCut.isLog(world, pos) && EventCallerFullTreeCut.isAxe(player.func_184614_ca()) ? (QuestFullTreeCut)this.quests.get(0) : null, (player, world, pos, state) -> {
            if (WorldUtils.getIsRemote(world) || !EventCallerFullTreeCut.isBreakingTree(world, pos)) {
                return;
            }
            this.executor.withHands((PlayerEntity)player, (leftHandStack, rightHandStack) -> new TreeChopTask((PlayerEntity)player, (IWorld)world, (BlockPos)pos, (ItemStack)rightHandStack).execute());
        });
    }

    public static boolean isAxe(ItemStack stack) {
        return stack.func_77973_b().getRegistryName().toString().toLowerCase().contains("_axe");
    }

    public static boolean isLog(IWorld world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().getRegistryName().toString().toLowerCase().contains("log");
    }

    public static boolean isBreakingTree(IWorld world, BlockPos pos) {
        BlockPos currentPos = null;
        Stack<BlockPos> candidates = new Stack<BlockPos>();
        candidates.add(pos);
        while (!candidates.isEmpty()) {
            BlockPos candidate = (BlockPos)candidates.pop();
            if (currentPos != null && candidate.func_177956_o() <= currentPos.func_177956_o() || !EventCallerFullTreeCut.isLog(world, candidate)) continue;
            currentPos = candidate.func_177984_a();
            while (EventCallerFullTreeCut.isLog(world, currentPos)) {
                currentPos = currentPos.func_177984_a();
            }
            candidates.add(currentPos.func_177978_c());
            candidates.add(currentPos.func_177974_f());
            candidates.add(currentPos.func_177968_d());
            candidates.add(currentPos.func_177976_e());
        }
        if (currentPos == null) {
            return false;
        }
        int distance = 3;
        int radius = -1;
        int leaves = 0;
        for (int x = 0; x < distance; ++x) {
            for (int y = 0; y < distance; ++y) {
                for (int z = 0; z < distance; ++z) {
                    BlockPos leaf = currentPos.func_177982_a(radius + x, radius + y, radius + z);
                    BlockState state = world.func_180495_p(leaf);
                    if (state.func_185904_a() != Material.field_151584_j || ++leaves < 5) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static final class TreeChopTask {
        private final PlayerEntity player;
        private final IWorld world;
        private final BlockPos pos;
        private final ItemStack rightHandStack;
        public Queue<BlockPos> blocks = new LinkedList<BlockPos>();
        public Set<BlockPos> visited = new HashSet<BlockPos>();

        public TreeChopTask(PlayerEntity player, IWorld world, BlockPos pos, ItemStack rightHandStack) {
            this.player = player;
            this.world = world;
            this.pos = pos;
            this.rightHandStack = rightHandStack;
            this.blocks.add(this.pos);
        }

        public void execute() {
            while (this.blocks.size() > 0) {
                BlockPos pos2;
                BlockPos current = this.blocks.remove();
                if (!this.visited.add(current) || !EventCallerFullTreeCut.isLog(this.world, current)) continue;
                for (Direction facing : Direction.Plane.HORIZONTAL) {
                    pos2 = current.func_177972_a(facing);
                    if (this.visited.contains(pos2)) continue;
                    this.blocks.add(pos2);
                }
                for (int x = 0; x < 3; ++x) {
                    for (int z = 0; z < 3; ++z) {
                        pos2 = current.func_177982_a(-1 + x, 1, -1 + z);
                        if (this.visited.contains(pos2)) continue;
                        this.blocks.add(pos2);
                    }
                }
                BlockUtils.breakBlock(this.rightHandStack, this.world, this.player, current);
            }
        }
    }
}

