/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.quests.eventcallers;

import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerUpgradable;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestItemTierUpgrade;
import com.github.sejoslaw.vanillamagic2.common.registries.ItemTierRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraftforge.registries.ForgeRegistries;

public class EventCallerItemTierUpgrade
extends EventCallerUpgradable<QuestItemTierUpgrade> {
    @Override
    protected boolean isBase(ItemStack stack) {
        return ItemTierRegistry.isBase(stack);
    }

    @Override
    protected boolean isIngredient(ItemStack stack) {
        return ItemTierRegistry.isIngredient(stack);
    }

    @Override
    protected List<ItemStack> getResults(List<ItemEntity> baseItems, List<ItemEntity> ingredients) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        Map<ItemEntity, Boolean> baseItemsChecked = baseItems.stream().collect(Collectors.toMap(e -> e, e -> false));
        for (Map.Entry<ItemEntity, Boolean> entry : baseItemsChecked.entrySet()) {
            ItemEntity ingredient;
            ItemEntity baseEntity = entry.getKey();
            if (entry.getValue().booleanValue() || !baseEntity.func_92059_d().func_77973_b().getRegistryName().func_110623_a().contains("_")) continue;
            ItemStack baseStack = baseEntity.func_92059_d();
            int tier = ItemTierRegistry.getTier(baseStack);
            if ((ingredient = this.getIngredient(++tier, ingredients)) == null) {
                entry.setValue(true);
                continue;
            }
            ItemStack result = this.buildResult(tier, baseStack);
            results.add(result);
        }
        return results;
    }

    private ItemEntity getIngredient(int tier, List<ItemEntity> ingredients) {
        return ingredients.stream().filter(entity -> ItemTierRegistry.getTier(entity.func_92059_d()) == tier).findFirst().orElse(null);
    }

    private ItemStack buildResult(int tier, ItemStack baseStack) {
        String itemKind = baseStack.func_77973_b().getRegistryName().func_110623_a().split("_")[1].toLowerCase();
        String tierType = ItemTierRegistry.getTierType(tier);
        String newPath = tierType + "_" + itemKind;
        Item item = (Item)ForgeRegistries.ITEMS.getEntries().stream().filter(entry -> ((RegistryKey)entry.getKey()).func_240901_a_().toString().toLowerCase().split(":")[1].equals(newPath)).findFirst().get().getValue();
        return new ItemStack((IItemProvider)item);
    }
}

