/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.quests.eventcallers;

import com.github.sejoslaw.vanillamagic2.common.quests.EventCaller;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestMoveBlock;
import com.github.sejoslaw.vanillamagic2.common.utils.TextUtils;
import com.github.sejoslaw.vanillamagic2.common.utils.WorldUtils;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventCallerMoveBlock
extends EventCaller<QuestMoveBlock> {
    private int counter = 0;

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (this.counter > 0) {
            this.counter = 0;
            return;
        }
        this.executor.onPlayerInteract((PlayerInteractEvent)event, (player, world, pos, direction) -> this.executor.withHands((PlayerEntity)player, (leftHandStack, rightHandStack) -> {
            if (this.canLoad((ItemStack)leftHandStack) && leftHandStack.func_77973_b() == Items.field_151134_bR) {
                this.execute((PlayerEntity)player, new ItemStack((IItemProvider)Items.field_151122_aG), bookStack -> this.load((IWorld)world, (BlockPos)pos, (Direction)direction, (ItemStack)leftHandStack));
            } else if (leftHandStack.func_77973_b() == Items.field_151122_aG) {
                this.execute((PlayerEntity)player, new ItemStack((IItemProvider)Items.field_151134_bR), bookStack -> this.save((ItemStack)bookStack, (IWorld)world, (BlockPos)pos));
            }
        }));
        ++this.counter;
    }

    private boolean canLoad(ItemStack leftHandStack) {
        CompoundNBT nbt = leftHandStack.func_196082_o();
        return nbt.func_74764_b("NBT_BLOCK") && nbt.func_74775_l("NBT_BLOCK").func_74764_b("NBT_BLOCK_STATE");
    }

    private void execute(PlayerEntity player, ItemStack bookStack, Consumer<ItemStack> consumer) {
        consumer.accept(bookStack);
        player.func_184201_a(EquipmentSlotType.OFFHAND, bookStack);
    }

    private void load(IWorld world, BlockPos pos, Direction direction, ItemStack leftHandStack) {
        CompoundNBT nbt = leftHandStack.func_196082_o().func_74775_l("NBT_BLOCK");
        BlockPos spawnPos = pos.func_177972_a(direction);
        if (!world.func_175623_d(spawnPos)) {
            return;
        }
        BlockState blockState = Block.func_196257_b((int)nbt.func_74762_e("NBT_BLOCK_STATE"));
        world.func_180501_a(spawnPos, blockState, 3);
        TileEntity tile = world.func_175625_s(spawnPos);
        if (tile != null) {
            nbt.func_74768_a("x", spawnPos.func_177958_n());
            nbt.func_74768_a("y", spawnPos.func_177956_o());
            nbt.func_74768_a("z", spawnPos.func_177952_p());
            tile.func_230337_a_(tile.func_195044_w(), nbt);
        }
    }

    private void save(ItemStack bookStack, IWorld world, BlockPos pos) {
        BlockState blockState = world.func_180495_p(pos);
        bookStack.func_200302_a(TextUtils.combine(TextUtils.translate("quest.moveBlock.block"), " " + TextUtils.getFormattedText(blockState.func_177230_c().func_149739_a())));
        CompoundNBT nbt = new CompoundNBT();
        bookStack.func_196082_o().func_218657_a("NBT_BLOCK", (INBT)nbt);
        nbt.func_74768_a("NBT_BLOCK_STATE", Block.func_196246_j((BlockState)blockState));
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            tileEntity.func_189515_b(nbt);
            bookStack.func_200302_a(TextUtils.combine(TextUtils.translate("quest.moveBlock.tileEntity"), " " + bookStack.func_200301_q().getString()));
            WorldUtils.asWorld(world).func_175713_t(pos);
            nbt.func_82580_o("x");
            nbt.func_82580_o("y");
            nbt.func_82580_o("z");
        }
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
    }
}

