/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.quests.eventcallers;

import com.github.sejoslaw.vanillamagic2.common.quests.EventCaller;
import com.github.sejoslaw.vanillamagic2.common.quests.Quest;
import com.github.sejoslaw.vanillamagic2.common.utils.WorldUtils;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public abstract class EventCallerUpgradable<TQuest extends Quest>
extends EventCaller<TQuest> {
    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        List[] items = new List[1];
        List[] baseItems = new List[1];
        List[] ingredients = new List[1];
        List[] results = new List[1];
        this.executor.onPlayerInteract((PlayerInteractEvent)event, (player, world, pos, direction) -> this.executor.click(Blocks.field_150383_bp, (IWorld)world, (BlockPos)pos, () -> {
            if (WorldUtils.getIsRemote(world)) {
                return null;
            }
            items[0] = WorldUtils.getItems(world, pos);
            baseItems[0] = items[0].stream().filter(entity -> this.isBase(entity.func_92059_d())).collect(Collectors.toList());
            ingredients[0] = items[0].stream().filter(entity -> this.isIngredient(entity.func_92059_d())).collect(Collectors.toList());
            if (baseItems[0].size() <= 0 || ingredients[0].size() <= 0) {
                return null;
            }
            results[0] = this.getResults(baseItems[0], ingredients[0]);
            if (results[0].size() <= 0) {
                return null;
            }
            return (Quest)this.quests.get(0);
        }), (player, world, pos, direction, quest) -> {
            baseItems[0].forEach(entity -> entity.func_92059_d().func_190918_g(1));
            ingredients[0].forEach(entity -> entity.func_92059_d().func_190918_g(1));
            WorldUtils.spawnOnCauldron(world, pos, results[0], ItemStack::func_190916_E);
        });
    }

    protected abstract boolean isBase(ItemStack var1);

    protected abstract boolean isIngredient(ItemStack var1);

    protected abstract List<ItemStack> getResults(List<ItemEntity> var1, List<ItemEntity> var2);
}

