/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.quests.types;

import com.github.sejoslaw.vanillamagic2.common.json.IJsonService;
import com.github.sejoslaw.vanillamagic2.common.quests.Quest;
import com.github.sejoslaw.vanillamagic2.common.utils.ItemStackUtils;
import com.github.sejoslaw.vanillamagic2.common.utils.TextUtils;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class QuestCraftOnAltar
extends Quest {
    public List<ItemStack> ingredients;
    public List<ItemStack> results;

    @Override
    public void readData(IJsonService jsonService) {
        super.readData(jsonService);
        this.ingredients = ItemStackUtils.getItemStacksFromJson(jsonService, "ingredients");
        this.results = ItemStackUtils.getItemStacksFromJson(jsonService, "results");
        if (this.iconStack == null || this.iconStack == ItemStack.field_190927_a) {
            this.iconStack = this.results.get(0);
        }
    }

    @Override
    public void fillTooltip(List<ITextComponent> lines) {
        super.fillTooltip(lines);
        TextUtils.addLine(lines, "quest.tooltip.ingredients", this.getTooltip(this.ingredients));
        TextUtils.addLine(lines, "quest.tooltip.results", this.getTooltip(this.results));
    }

    @Override
    public String getDisplayName() {
        return TextUtils.getFormattedText("quest.craftOnAltar.prefix") + " " + TextUtils.getFormattedText(this.results.get(0).func_77977_a());
    }

    @Override
    public String getDescription() {
        return TextUtils.getFormattedText("quest.craftOnAltar.desc");
    }
}

