/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.quests.types;

import com.github.sejoslaw.vanillamagic2.common.json.IJsonService;
import com.github.sejoslaw.vanillamagic2.common.quests.Quest;
import com.github.sejoslaw.vanillamagic2.common.utils.TextUtils;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class QuestMineBlock
extends Quest {
    public List<Block> blocksToMine;

    @Override
    public void readData(IJsonService jsonService) {
        super.readData(jsonService);
        String blockName = jsonService.getString("blocksToMine").toLowerCase();
        this.blocksToMine = ForgeRegistries.BLOCKS.getEntries().stream().filter(entry -> ((RegistryKey)entry.getKey()).func_240901_a_().toString().toLowerCase().contains(blockName)).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @Override
    public void fillTooltip(List<ITextComponent> lines) {
        super.fillTooltip(lines);
        TextUtils.addLine(lines, "quest.tooltip.blocksToMine", this.blocksToMine.stream().map(this::getTooltip).collect(Collectors.joining(", ")));
    }
}

