/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.registries;

import com.github.sejoslaw.vanillamagic2.common.entities.EntityMeteor;
import com.github.sejoslaw.vanillamagic2.common.entities.EntitySpell;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public final class EntityRegistry {
    private static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"vanillamagic2");
    public static final RegistryObject<EntityType<EntitySpell>> SPELL = ENTITIES.register(EntitySpell.class.getName().toLowerCase(), () -> EntityRegistry.buildEntityType(EntitySpell::new, EntitySpell.class.getName().toLowerCase()));
    public static final RegistryObject<EntityType<EntityMeteor>> METEOR = ENTITIES.register(EntityMeteor.class.getName().toLowerCase(), () -> EntityRegistry.buildEntityType(EntityMeteor::new, EntityMeteor.class.getName().toLowerCase()));

    public static void initialize() {
        ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    private static <T extends Entity> EntityType<T> buildEntityType(EntityType.IFactory<T> factory, String registryName) {
        return EntityType.Builder.func_220322_a(factory, (EntityClassification)EntityClassification.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(50).setUpdateInterval(60).func_220321_a(1.0f, 1.0f).func_206830_a(registryName);
    }
}

