/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.registries;

import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.IMachineModule;
import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.modules.ForgeCapabilityEnergyModule;
import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.modules.ForgeEnergyModule;
import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.modules.QuarryLogicModule;
import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.modules.SmeltableTicksEnergyModule;
import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.modules.breeders.FindingBreederLogicModule;
import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.modules.breeders.UsingItemBreederLogicModule;
import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.modules.farms.BoneMealApplyingFarmLogicModule;
import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.modules.farms.FarmingFarmLogicModule;
import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.modules.farms.ItemCollectingFarmLogicModule;
import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.modules.farms.PlantingFarmLogicModule;
import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.modules.farms.TreeCuttingFarmLogicModule;
import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.modules.farms.WorkingPosMoverFarmLogicModule;
import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.modules.killers.AttackingKillerLogicModule;
import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.modules.killers.SwordFindingKillerLogicModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MachineModuleRegistry {
    public static final List<IMachineModule> DEFAULT_MODULES = new ArrayList<IMachineModule>();
    public static final Map<String, List<IMachineModule>> MODULES = new HashMap<String, List<IMachineModule>>();
    public static final String QUARRY_KEY = "quarry";
    public static final String FARM_KEY = "farm";
    public static final String KILLER_KEY = "killer";
    public static final String BREEDER_KEY = "breeder";

    public static void initialize() {
        DEFAULT_MODULES.add(new SmeltableTicksEnergyModule());
        DEFAULT_MODULES.add(new ForgeEnergyModule());
        DEFAULT_MODULES.add(new ForgeCapabilityEnergyModule());
        MachineModuleRegistry.registerModule(QUARRY_KEY, new QuarryLogicModule());
        MachineModuleRegistry.registerModule(FARM_KEY, new WorkingPosMoverFarmLogicModule());
        MachineModuleRegistry.registerModule(FARM_KEY, new PlantingFarmLogicModule());
        MachineModuleRegistry.registerModule(FARM_KEY, new BoneMealApplyingFarmLogicModule());
        MachineModuleRegistry.registerModule(FARM_KEY, new TreeCuttingFarmLogicModule());
        MachineModuleRegistry.registerModule(FARM_KEY, new FarmingFarmLogicModule());
        MachineModuleRegistry.registerModule(FARM_KEY, new ItemCollectingFarmLogicModule());
        MachineModuleRegistry.registerModule(KILLER_KEY, new SwordFindingKillerLogicModule());
        MachineModuleRegistry.registerModule(KILLER_KEY, new AttackingKillerLogicModule());
        MachineModuleRegistry.registerModule(BREEDER_KEY, new FindingBreederLogicModule());
        MachineModuleRegistry.registerModule(BREEDER_KEY, new UsingItemBreederLogicModule());
    }

    private static void registerModule(String key, IMachineModule module) {
        if (!MODULES.containsKey(key)) {
            MODULES.put(key, new ArrayList());
        }
        MODULES.get(key).add(module);
    }
}

