/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.registries;

import com.github.sejoslaw.vanillamagic2.common.json.IJsonService;
import com.github.sejoslaw.vanillamagic2.common.quests.Quest;
import com.github.sejoslaw.vanillamagic2.common.quests.QuestEventCaller;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerArrowMachineGun;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerBuildAltar;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerCaptureEntity;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerCastSpellInAir;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerCastSpellOnBlock;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerCastSpellSummon;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerCraft;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerCraftOnAltar;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerCrystallizedLiquid;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerCrystallizedPotion;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerFullTreeCut;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerItemMagnet;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerItemTierUpgrade;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerItemUpgrade;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerJumper;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerMineBlock;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerMobSpawnerDrop;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerMoveBlock;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerOreMultiplier;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerPickup;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerPortableCraftingTable;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerShootWitherSkull;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerSmeltOnAltar;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerSummonHorde;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.items.EventCallerAccelerationCrystal;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.items.EventCallerEvokerCrystal;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.items.EventCallerLiquidSuppressionCrystal;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.items.EventCallerMotherNatureCrystal;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.tileentities.EventCallerAccelerant;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.tileentities.EventCallerBlockAbsorber;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.tileentities.EventCallerBreeder;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.tileentities.EventCallerFarm;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.tileentities.EventCallerInventoryBridge;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.tileentities.EventCallerKiller;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.tileentities.EventCallerQuarry;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestArrowMachineGun;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestBuildAltar;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestCaptureEntity;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestCastSpellInAir;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestCastSpellOnBlock;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestCastSpellSummon;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestCraft;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestCraftOnAltar;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestCrystallizedLiquid;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestCrystallizedPotion;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestFullTreeCut;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestItemMagnet;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestItemTierUpgrade;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestItemUpgrade;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestJumper;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestMineBlock;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestMobSpawnerDrop;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestMoveBlock;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestOreMultiplier;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestPickup;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestPortableCraftingTable;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestShootWitherSkull;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestSmeltOnAltar;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestSummonHorde;
import com.github.sejoslaw.vanillamagic2.common.quests.types.items.QuestAccelerationCrystal;
import com.github.sejoslaw.vanillamagic2.common.quests.types.items.QuestEvokerCrystal;
import com.github.sejoslaw.vanillamagic2.common.quests.types.items.QuestLiquidSuppressionCrystal;
import com.github.sejoslaw.vanillamagic2.common.quests.types.items.QuestMotherNatureCrystal;
import com.github.sejoslaw.vanillamagic2.common.quests.types.tileentities.QuestAccelerant;
import com.github.sejoslaw.vanillamagic2.common.quests.types.tileentities.QuestBlockAbsorber;
import com.github.sejoslaw.vanillamagic2.common.quests.types.tileentities.QuestBreeder;
import com.github.sejoslaw.vanillamagic2.common.quests.types.tileentities.QuestFarm;
import com.github.sejoslaw.vanillamagic2.common.quests.types.tileentities.QuestInventoryBridge;
import com.github.sejoslaw.vanillamagic2.common.quests.types.tileentities.QuestKiller;
import com.github.sejoslaw.vanillamagic2.common.quests.types.tileentities.QuestQuarry;
import com.github.sejoslaw.vanillamagic2.core.VMLogger;
import java.util.ArrayList;
import java.util.List;

public final class QuestRegistry {
    private static final List<QuestEventCaller> QUEST_EVENT_CALLERS = new ArrayList<QuestEventCaller>();

    public static void initialize() {
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("fullTreeCut", EventCallerFullTreeCut.class, QuestFullTreeCut.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("mobSpawnerDrop", EventCallerMobSpawnerDrop.class, QuestMobSpawnerDrop.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("portableCraftingTable", EventCallerPortableCraftingTable.class, QuestPortableCraftingTable.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("castSpellInAir", EventCallerCastSpellInAir.class, QuestCastSpellInAir.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("castSpellOnBlock", EventCallerCastSpellOnBlock.class, QuestCastSpellOnBlock.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("castSpellSummon", EventCallerCastSpellSummon.class, QuestCastSpellSummon.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("itemUpgrade", EventCallerItemUpgrade.class, QuestItemUpgrade.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("itemTierUpgrade", EventCallerItemTierUpgrade.class, QuestItemTierUpgrade.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("arrowMachineGun", EventCallerArrowMachineGun.class, QuestArrowMachineGun.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("buildAltar", EventCallerBuildAltar.class, QuestBuildAltar.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("captureEntity", EventCallerCaptureEntity.class, QuestCaptureEntity.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("craft", EventCallerCraft.class, QuestCraft.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("craftOnAltar", EventCallerCraftOnAltar.class, QuestCraftOnAltar.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("itemMagnet", EventCallerItemMagnet.class, QuestItemMagnet.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("jumper", EventCallerJumper.class, QuestJumper.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("mineBlock", EventCallerMineBlock.class, QuestMineBlock.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("moveBlock", EventCallerMoveBlock.class, QuestMoveBlock.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("oreMultiplier", EventCallerOreMultiplier.class, QuestOreMultiplier.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("pickup", EventCallerPickup.class, QuestPickup.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("shootWitherSkull", EventCallerShootWitherSkull.class, QuestShootWitherSkull.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("smeltOnAltar", EventCallerSmeltOnAltar.class, QuestSmeltOnAltar.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("summonHorde", EventCallerSummonHorde.class, QuestSummonHorde.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("accelerationCrystal", EventCallerAccelerationCrystal.class, QuestAccelerationCrystal.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("crystallizedLiquid", EventCallerCrystallizedLiquid.class, QuestCrystallizedLiquid.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("evokerCrystal", EventCallerEvokerCrystal.class, QuestEvokerCrystal.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("liquidSuppressionCrystal", EventCallerLiquidSuppressionCrystal.class, QuestLiquidSuppressionCrystal.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("crystallizedPotion", EventCallerCrystallizedPotion.class, QuestCrystallizedPotion.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("motherNatureCrystal", EventCallerMotherNatureCrystal.class, QuestMotherNatureCrystal.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("blockAbsorber", EventCallerBlockAbsorber.class, QuestBlockAbsorber.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("inventoryBridge", EventCallerInventoryBridge.class, QuestInventoryBridge.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("accelerant", EventCallerAccelerant.class, QuestAccelerant.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("quarry", EventCallerQuarry.class, QuestQuarry.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("farm", EventCallerFarm.class, QuestFarm.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("killer", EventCallerKiller.class, QuestKiller.class).register());
        QUEST_EVENT_CALLERS.add(new QuestEventCaller("breeder", EventCallerBreeder.class, QuestBreeder.class).register());
    }

    public static void readQuest(IJsonService jsonService) {
        String questEventCallerKey = jsonService.getString("eventCaller");
        QuestEventCaller caller = QUEST_EVENT_CALLERS.stream().filter(c -> c.key.equals(questEventCallerKey)).findFirst().orElse(null);
        if (caller == null) {
            VMLogger.logError("Unknown EventCaller: " + questEventCallerKey);
            return;
        }
        caller.addNewQuest(jsonService);
    }

    public static Quest getQuest(String questUniqueName) {
        for (QuestEventCaller caller : QUEST_EVENT_CALLERS) {
            for (Quest quest : caller.getEventCaller().quests) {
                if (!quest.uniqueName.equals(questUniqueName)) continue;
                return quest;
            }
        }
        if (questUniqueName.isEmpty()) {
            return null;
        }
        throw new IllegalArgumentException("Unknown Quest: " + questUniqueName);
    }

    public static List<Quest> getQuests() {
        ArrayList<Quest> quests = new ArrayList<Quest>();
        QUEST_EVENT_CALLERS.forEach(caller -> quests.addAll(caller.getEventCaller().quests));
        return quests;
    }
}

