/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.registries;

import com.github.sejoslaw.vanillamagic2.common.spells.summon.logics.EndermiteSummonLogic;
import com.github.sejoslaw.vanillamagic2.common.spells.summon.logics.GuardianSummonLogic;
import com.github.sejoslaw.vanillamagic2.common.spells.summon.logics.MagmaCubeSummonLogic;
import com.github.sejoslaw.vanillamagic2.common.spells.summon.logics.PiglinBruteSummonLogic;
import com.github.sejoslaw.vanillamagic2.common.spells.summon.logics.PiglinSummonLogic;
import com.github.sejoslaw.vanillamagic2.common.spells.summon.logics.SkeletonSummonLogic;
import com.github.sejoslaw.vanillamagic2.common.spells.summon.logics.SlimeSummonLogic;
import com.github.sejoslaw.vanillamagic2.common.spells.summon.logics.SpiderSummonLogic;
import com.github.sejoslaw.vanillamagic2.common.spells.summon.logics.StraySummonLogic;
import com.github.sejoslaw.vanillamagic2.common.spells.summon.logics.SummonEntityLogic;
import com.github.sejoslaw.vanillamagic2.common.spells.summon.logics.VexSummonLogic;
import com.github.sejoslaw.vanillamagic2.common.spells.summon.logics.VillagerSummonLogic;
import com.github.sejoslaw.vanillamagic2.common.spells.summon.logics.WitherSkeletonSummonLogic;
import com.github.sejoslaw.vanillamagic2.common.spells.summon.logics.ZombifiedPiglinSummonLogic;
import com.github.sejoslaw.vanillamagic2.common.utils.WorldUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.world.IWorld;

public final class SummonEntityLogicRegistry {
    private static final Set<SummonEntityLogic> LOGICS = new HashSet<SummonEntityLogic>();

    public static void initialize() {
        LOGICS.add(new SkeletonSummonLogic());
        LOGICS.add(new SpiderSummonLogic());
        LOGICS.add(new SlimeSummonLogic());
        LOGICS.add(new GuardianSummonLogic());
        LOGICS.add(new VexSummonLogic());
        LOGICS.add(new StraySummonLogic());
        LOGICS.add(new VillagerSummonLogic());
        LOGICS.add(new PiglinSummonLogic());
        LOGICS.add(new ZombifiedPiglinSummonLogic());
        LOGICS.add(new PiglinBruteSummonLogic());
        LOGICS.add(new MagmaCubeSummonLogic());
        LOGICS.add(new WitherSkeletonSummonLogic());
        LOGICS.add(new EndermiteSummonLogic());
    }

    public static Entity getEntity(IWorld world, EntityType<? extends Entity> defaultType) {
        SummonEntityLogic logic = SummonEntityLogicRegistry.find(defaultType);
        return logic != null ? logic.getEntity(world) : defaultType.func_200721_a(WorldUtils.asWorld(world));
    }

    public static Entity getHorse(IWorld world, EntityType<? extends Entity> defaultType) {
        SummonEntityLogic logic = SummonEntityLogicRegistry.find(defaultType);
        return logic != null ? logic.getHorse(world) : null;
    }

    public static double getPercent(EntityType<? extends Entity> defaultType) {
        SummonEntityLogic logic = SummonEntityLogicRegistry.find(defaultType);
        return logic != null ? (double)logic.getPercent() : 0.0;
    }

    private static SummonEntityLogic find(EntityType<? extends Entity> defaultType) {
        return LOGICS.stream().filter(logic -> logic.entityType == defaultType).findFirst().orElse(null);
    }
}

