/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.spells.evokers;

import com.github.sejoslaw.vanillamagic2.common.spells.evokers.EvokerSpell;
import com.github.sejoslaw.vanillamagic2.common.utils.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.EvokerFangsEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class EvokerSpellFangs
extends EvokerSpell {
    @Override
    public void cast(IWorld world, PlayerEntity player, Entity target) {
        if (target == null) {
            return;
        }
        double minDifY = Math.min(target.func_226278_cu_(), player.func_226278_cu_());
        double maxDifY = Math.max(target.func_226278_cu_(), player.func_226278_cu_()) + 1.0;
        float distance = (float)MathHelper.func_181159_b((double)(target.func_226281_cx_() - player.func_226281_cx_()), (double)(target.func_226277_ct_() - player.func_226277_ct_()));
        if (player.func_70068_e(target) < 9.0) {
            float distance1;
            int i;
            for (i = 0; i < 5; ++i) {
                distance1 = distance + (float)i * (float)Math.PI * 0.4f;
                this.spawnFangs(world, player, player.func_226277_ct_() + (double)MathHelper.func_76134_b((float)distance1) * 1.5, player.func_226281_cx_() + (double)MathHelper.func_76126_a((float)distance1) * 1.5, minDifY, maxDifY, distance1, 0);
            }
            for (i = 0; i < 8; ++i) {
                distance1 = distance + (float)i * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                this.spawnFangs(world, player, player.func_226277_ct_() + (double)MathHelper.func_76134_b((float)distance1) * 2.5, player.func_226281_cx_() + (double)MathHelper.func_76126_a((float)distance1) * 2.5, minDifY, maxDifY, distance1, 3);
            }
        } else {
            for (int l = 0; l < 16; ++l) {
                double distance1 = 1.25 * (double)(l + 1);
                this.spawnFangs(world, player, player.func_226277_ct_() + (double)MathHelper.func_76134_b((float)distance) * distance1, player.func_226281_cx_() + (double)MathHelper.func_76126_a((float)distance) * distance1, minDifY, maxDifY, distance, l);
            }
        }
        player.func_184185_a(SoundEvents.field_191247_bq, 1.0f, 1.0f);
    }

    private void spawnFangs(IWorld world, PlayerEntity player, double nextX, double nextZ, double minDifY, double maxDifY, float distance, int warmupDelayTicks) {
        BlockPos pos = new BlockPos(nextX, maxDifY, nextZ);
        boolean flag = false;
        double maxY = 0.0;
        do {
            BlockState state;
            VoxelShape shape;
            BlockPos downPos;
            BlockState stateDown;
            if (!(stateDown = world.func_180495_p(downPos = pos.func_177977_b())).func_224755_d((IBlockReader)world, downPos, Direction.UP)) continue;
            if (!world.func_175623_d(pos) && !(shape = (state = world.func_180495_p(pos)).func_196952_d((IBlockReader)world, pos)).func_197766_b()) {
                maxY = shape.func_197758_c(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((pos = pos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)minDifY) - 1);
        if (flag) {
            world.func_217376_c((Entity)new EvokerFangsEntity(WorldUtils.asWorld(world), nextX, (double)pos.func_177956_o() + maxY, nextZ, distance, warmupDelayTicks, (LivingEntity)player));
        }
    }
}

