/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.tileentities;

import com.github.sejoslaw.vanillamagic2.common.registries.TileEntityRegistry;
import com.github.sejoslaw.vanillamagic2.common.tileentities.VMTileEntity;
import com.github.sejoslaw.vanillamagic2.common.utils.BlockUtils;
import com.github.sejoslaw.vanillamagic2.common.utils.NbtUtils;
import com.github.sejoslaw.vanillamagic2.common.utils.WorldUtils;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class VMTileInventoryBridge
extends VMTileEntity {
    private long sourcePos;
    private String sourceDimId;
    private IInventory sourceInv;
    private IInventory destinationInv;

    public VMTileInventoryBridge() {
        super((TileEntityType<? extends VMTileEntity>)((TileEntityType)TileEntityRegistry.INVENTORY_BRIDGE.get()));
    }

    public void setSource(CompoundNBT nbt) {
        this.sourcePos = nbt.func_74763_f("NBT_POSITION");
        this.sourceDimId = nbt.func_74779_i("NBT_DIMENSION");
        this.destinationInv = WorldUtils.getInventory((IWorld)this.func_145831_w(), this.func_174877_v().func_177972_a(Direction.DOWN));
        ServerWorld sourceWorld = NbtUtils.getWorld(this.func_145831_w().func_73046_m(), nbt);
        this.sourceInv = WorldUtils.getInventory((IWorld)sourceWorld, BlockPos.func_218283_e((long)this.sourcePos));
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.setSource(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74772_a("NBT_POSITION", this.sourcePos);
        compound.func_74778_a("NBT_DIMENSION", this.sourceDimId);
        return compound;
    }

    @Override
    public void tickTileEntity() {
        if (this.destinationInv == null || this.sourceInv == null) {
            this.func_145843_s();
            return;
        }
        for (int i = 0; i < this.sourceInv.func_70302_i_(); ++i) {
            HopperTileEntity.func_174918_a((IInventory)this.sourceInv, (IInventory)this.destinationInv, (ItemStack)this.sourceInv.func_70301_a(i), null);
        }
    }

    public static Block[] getValidBlocks() {
        List<Block> blocks = ForgeRegistries.BLOCKS.getValues().stream().filter(block -> block.hasTileEntity(block.func_176223_P())).collect(Collectors.toList());
        return BlockUtils.getValidBlocks(blocks);
    }
}

