/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.tileentities.machines;

import com.github.sejoslaw.vanillamagic2.common.registries.MachineModuleRegistry;
import com.github.sejoslaw.vanillamagic2.common.registries.TileEntityRegistry;
import com.github.sejoslaw.vanillamagic2.common.tileentities.VMTileEntity;
import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.IVMTileMachine;
import com.github.sejoslaw.vanillamagic2.common.utils.TextUtils;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;

public class VMTileMachine
extends VMTileEntity
implements IVMTileMachine {
    private String moduleKey;

    public VMTileMachine() {
        super((TileEntityType<? extends VMTileEntity>)((TileEntityType)TileEntityRegistry.MACHINE.get()));
    }

    public void setModuleKey(String key) {
        this.moduleKey = key;
        MachineModuleRegistry.DEFAULT_MODULES.forEach(module -> module.setup(this));
        MachineModuleRegistry.MODULES.get(this.moduleKey).forEach(machine -> machine.setup(this));
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74778_a("NBT_MACHINE_MODULE_KEY", this.moduleKey);
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.setModuleKey(nbt.func_74779_i("NBT_MACHINE_MODULE_KEY"));
    }

    @Override
    public void tickTileEntity() {
        if (!MachineModuleRegistry.DEFAULT_MODULES.stream().allMatch(module -> module.canExecute(this))) {
            return;
        }
        MachineModuleRegistry.DEFAULT_MODULES.forEach(module -> module.execute(this));
        if (MachineModuleRegistry.MODULES.get(this.moduleKey).stream().allMatch(machine -> machine.canExecute(this))) {
            MachineModuleRegistry.MODULES.get(this.moduleKey).forEach(machine -> machine.execute(this));
        }
    }

    @Override
    public void addInformation(List<ITextComponent> lines) {
        TextUtils.addLine(lines, "vm.tooltip.tile.machine.type", TextUtils.firstLetterToUpper(this.moduleKey));
    }
}

