/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.tileentities.machines.modules;

import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.IVMTileMachine;
import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.modules.AbstractMachineModule;
import com.github.sejoslaw.vanillamagic2.common.utils.WorldUtils;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Items;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public abstract class AbstractLogicModule
extends AbstractMachineModule {
    @Override
    public boolean canExecute(IVMTileMachine machine) {
        return this.getHasEnergy(machine) && this.checkStructure(machine);
    }

    @Override
    public void execute(IVMTileMachine machine) {
        this.work(machine);
        int energyLevel = this.getEnergyLevel(machine);
        this.setEnergyLevel(machine, energyLevel - 1);
    }

    protected IInventory getInventory(IVMTileMachine machine) {
        return (IInventory)machine.getWorld().func_175625_s(this.getInputStoragePos(machine));
    }

    protected int getSize(IVMTileMachine machine) {
        return 1 + this.getInventory(machine).func_213901_a(Items.field_221732_cb);
    }

    protected FakePlayer getFakePlayer(IWorld world, GameProfile profile) {
        return FakePlayerFactory.get((ServerWorld)((ServerWorld)world), (GameProfile)profile);
    }

    protected <T extends Entity> List<T> getEntities(IVMTileMachine machine, Class<T> clazz, Predicate<T> check) {
        return WorldUtils.getEntities(machine.getWorld(), clazz, machine.getPos(), this.getSize(machine), check);
    }

    protected abstract boolean checkStructure(IVMTileMachine var1);

    protected abstract void work(IVMTileMachine var1);
}

