/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.tileentities.machines.modules.farms;

import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.IVMTileMachine;
import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.modules.farms.AbstractFarmLogicModule;
import com.github.sejoslaw.vanillamagic2.common.utils.BlockUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.AbstractTopPlantBlock;
import net.minecraft.block.BambooBlock;
import net.minecraft.block.BeetrootBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CactusBlock;
import net.minecraft.block.CocoaBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.block.SeaPickleBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.block.SugarCaneBlock;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class FarmingFarmLogicModule
extends AbstractFarmLogicModule {
    private List<IFarmer> farmers = new ArrayList<IFarmer>();

    public FarmingFarmLogicModule() {
        this.addFarmer(AbstractTopPlantBlock.class, AbstractTopPlantBlock.field_235502_d_);
        this.addFarmer(BambooBlock.class, BambooBlock.field_220264_d);
        this.addFarmer(BeetrootBlock.class, BeetrootBlock.field_185531_a);
        this.addFarmer(CactusBlock.class, CactusBlock.field_176587_a);
        this.addFarmer(CocoaBlock.class, CocoaBlock.field_176501_a);
        this.addFarmer(CropsBlock.class, CropsBlock.field_176488_a);
        this.addFarmer(NetherWartBlock.class, NetherWartBlock.field_176486_a);
        this.addFarmer(SeaPickleBlock.class, SeaPickleBlock.field_204902_a);
        this.addFarmer(StemBlock.class, StemBlock.field_176484_a);
        this.addFarmer(SugarCaneBlock.class, SugarCaneBlock.field_176355_a);
        this.addFarmer(SweetBerryBushBlock.class, SweetBerryBushBlock.field_220125_a);
    }

    @Override
    protected void work(IVMTileMachine machine) {
        this.executeLogic(machine, (world, stack, pos) -> this.farmers.stream().anyMatch(farmer -> farmer.isFullyGrown((IWorld)world, (BlockPos)pos)), (world, stack, pos) -> BlockUtils.breakBlock(ItemStack.field_190927_a, world, (PlayerEntity)this.getFakePlayer((IWorld)world), pos));
    }

    private <T extends Block> void addFarmer(Class<T> clazz, IntegerProperty prop) {
        this.farmers.add(new Farmer<T>(clazz, state -> (Integer)state.func_177229_b((Property)prop) == BlockUtils.getMaxValue(prop)));
    }

    private static class Farmer<TBlock extends Block>
    implements IFarmer {
        private Class<TBlock> clazz;
        private Predicate<BlockState> predicate;

        public Farmer(Class<TBlock> clazz, Predicate<BlockState> predicate) {
            this.clazz = clazz;
            this.predicate = predicate;
        }

        @Override
        public boolean isFullyGrown(IWorld world, BlockPos pos) {
            BlockState state = world.func_180495_p(pos);
            return this.clazz.isInstance(state.func_177230_c()) && this.predicate.test(state);
        }
    }

    private static interface IFarmer {
        public boolean isFullyGrown(IWorld var1, BlockPos var2);
    }
}

