/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.utils;

import com.github.sejoslaw.vanillamagic2.common.functions.Function2;
import com.github.sejoslaw.vanillamagic2.common.utils.ItemStackUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public final class AltarUtils {
    public static final Map<Integer, Block> BLOCKS = new HashMap<Integer, Block>();

    public static boolean checkAltarTier(IWorld world, BlockPos pos, int tier) {
        Block block = BLOCKS.get(tier);
        if (tier <= 1) {
            return AltarUtils.checkTierNSidesOnly(world, pos.func_177984_a(), tier, block) && AltarUtils.checkTierNCornersOnly(world, pos.func_177984_a(), tier, block);
        }
        if (AltarUtils.checkAltarTier(world, pos, tier - 1)) {
            return tier % 2 == 0 ? AltarUtils.checkTierNSidesOnly(world, pos, tier, block) : AltarUtils.checkTierNCornersOnly(world, pos, tier, block);
        }
        return false;
    }

    public static boolean canCraftOnAltar(List<ItemStack> ingredients, List<ItemEntity> ingredientsInCauldron, Function2<ItemStack, ItemStack, Boolean> optionalCheck) {
        ArrayList<ItemEntity> validItemEntities = new ArrayList<ItemEntity>();
        if (optionalCheck == null) {
            optionalCheck = (requiredIngredientStack, ingredientInCauldronStack) -> true;
        }
        block0: for (ItemStack currentlyCheckedIngredient : ingredients) {
            for (ItemEntity currentlyCheckedItemEntity : ingredientsInCauldron) {
                ItemStack currentlyCheckedItemStack = currentlyCheckedItemEntity.func_92059_d();
                if (!ItemStackUtils.areEqual(currentlyCheckedIngredient, currentlyCheckedItemStack, true) || !optionalCheck.apply(currentlyCheckedIngredient, currentlyCheckedItemStack).booleanValue()) continue;
                validItemEntities.add(currentlyCheckedItemEntity);
                continue block0;
            }
        }
        return ingredients.size() == validItemEntities.size();
    }

    private static boolean checkTierNCornersOnly(IWorld world, BlockPos pos, int distance, Block block) {
        BlockPos up = new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p() + distance);
        BlockPos left = new BlockPos(pos.func_177958_n() - distance, pos.func_177956_o() - 1, pos.func_177952_p());
        BlockPos down = new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p() - distance);
        BlockPos right = new BlockPos(pos.func_177958_n() + distance, pos.func_177956_o() - 1, pos.func_177952_p());
        return world.func_180495_p(up).func_177230_c() == block && world.func_180495_p(left).func_177230_c() == block && world.func_180495_p(down).func_177230_c() == block && world.func_180495_p(right).func_177230_c() == block;
    }

    private static boolean checkTierNSidesOnly(IWorld world, BlockPos pos, int distance, Block block) {
        BlockPos rightUp = new BlockPos(pos.func_177958_n() + distance, pos.func_177956_o() - 1, pos.func_177952_p() + distance);
        BlockPos leftUp = new BlockPos(pos.func_177958_n() - distance, pos.func_177956_o() - 1, pos.func_177952_p() + distance);
        BlockPos leftDown = new BlockPos(pos.func_177958_n() - distance, pos.func_177956_o() - 1, pos.func_177952_p() - distance);
        BlockPos rightDown = new BlockPos(pos.func_177958_n() + distance, pos.func_177956_o() - 1, pos.func_177952_p() - distance);
        return world.func_180495_p(rightUp).func_177230_c() == block && world.func_180495_p(leftUp).func_177230_c() == block && world.func_180495_p(leftDown).func_177230_c() == block && world.func_180495_p(rightDown).func_177230_c() == block;
    }
}

