/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.utils;

import com.github.sejoslaw.vanillamagic2.common.utils.TextUtils;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public final class EntityUtils {
    public static String getPlayerNameFormatted(PlayerEntity player) {
        return TextUtils.getFormattedText(player.func_200200_C_());
    }

    public static List<EntityType<?>> getEntitiesByClassification(EntityClassification classification) {
        return ForgeRegistries.ENTITIES.getValues().stream().filter(type -> type.func_220339_d() == classification).collect(Collectors.toList());
    }

    public static void teleport(Entity entity, BlockPos newPos, RegistryKey<World> key) {
        World world = entity.func_130014_f_();
        MinecraftServer server = world.func_73046_m();
        if (server == null) {
            return;
        }
        ServerWorld serverWorld = world.func_73046_m().func_71218_a(key);
        if (serverWorld != null && entity instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)entity).func_200619_a(serverWorld, (double)newPos.func_177958_n(), (double)newPos.func_177956_o(), (double)newPos.func_177952_p(), ((ServerPlayerEntity)entity).field_71109_bG, entity.field_70125_A);
        }
    }

    public static Entity getLookingAt(Entity entity) {
        if (Minecraft.func_71410_x().field_71476_x instanceof EntityRayTraceResult) {
            return ((EntityRayTraceResult)Minecraft.func_71410_x().field_71476_x).func_216348_a();
        }
        return null;
    }

    public static void spawnLightningBolt(IWorld world, LightningBoltEntity entity) {
        entity.func_233623_a_(false);
        world.func_217376_c((Entity)entity);
    }

    public static void setupAcceleration(DamagingProjectileEntity entity, double accelX, double accelY, double accelZ) {
        double distance = MathHelper.func_76133_a((double)(accelX * accelX + accelY * accelY + accelZ * accelZ));
        entity.field_70232_b = accelX / distance * 0.1;
        entity.field_70233_c = accelY / distance * 0.1;
        entity.field_70230_d = accelZ / distance * 0.1;
    }
}

