/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.utils;

import com.github.sejoslaw.vanillamagic2.common.json.IJsonService;
import com.github.sejoslaw.vanillamagic2.common.json.JsonItemStack;
import com.github.sejoslaw.vanillamagic2.common.utils.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public final class ItemStackUtils {
    public static ItemStack getItemStackFromJson(JsonItemStack jsonItemStack) {
        try {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("id", jsonItemStack.getId());
            byte count = jsonItemStack.getCount();
            nbt.func_74774_a("Count", count <= 0 ? (byte)1 : count);
            int meta = jsonItemStack.getMeta();
            nbt.func_74768_a("Damage", Math.max(meta, 0));
            return ItemStack.func_199557_a((CompoundNBT)nbt);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static List<ItemStack> getItemStacksFromJson(IJsonService rootService, String key) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (IJsonService service : rootService.getList(key)) {
            ItemStack stack = ItemStackUtils.getItemStackFromJson(service.toItemStack());
            stacks.add(stack);
        }
        return stacks;
    }

    public static int getBurnTicks(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack);
    }

    public static boolean isFuel(ItemStack stack) {
        return AbstractFurnaceTileEntity.func_213991_b((ItemStack)stack);
    }

    public static List<ItemStack> smeltItems(PlayerEntity player, List<ItemEntity> stacksToSmelt, int smeltingCost) {
        ItemStack leftHandStack = player.func_184592_cb();
        World world = player.field_70170_p;
        int[] ticks = new int[]{0};
        return stacksToSmelt.stream().map(arg_0 -> ItemStackUtils.lambda$smeltItems$0(smeltingCost, leftHandStack, ticks, (IWorld)world, player, arg_0)).filter(stack -> stack != ItemStack.field_190927_a).collect(Collectors.toList());
    }

    public static float getExperienceFromStack(ItemStack stack, IWorld world) {
        AbstractCookingRecipe cookingRecipe = WorldUtils.asWorld(world).func_199532_z().func_199510_b().stream().filter(recipe -> recipe.func_222127_g() == IRecipeType.field_222150_b && recipe instanceof AbstractCookingRecipe && ItemStackUtils.areEqual(recipe.func_77571_b(), stack, true)).findFirst().orElse(null);
        return cookingRecipe == null ? 0.0f : cookingRecipe.func_222138_b();
    }

    public static ItemStack getSmeltingResultAsNewStack(ItemStack stackToSmelt, IWorld world) {
        IRecipe recipe = WorldUtils.asWorld(world).func_199532_z().func_199510_b().stream().filter(checkingRecipe -> checkingRecipe.func_222127_g() == IRecipeType.field_222150_b && ((Ingredient)checkingRecipe.func_192400_c().get(0)).test(stackToSmelt)).findFirst().orElse(null);
        return recipe == null ? ItemStack.field_190927_a : recipe.func_77571_b().func_77946_l();
    }

    public static List<ItemEntity> getSmeltables(IWorld world, BlockPos pos) {
        return WorldUtils.getItems(world, pos).stream().filter(itemEntity -> ItemStackUtils.getSmeltingResultAsNewStack(itemEntity.func_92059_d(), world) != ItemStack.field_190927_a).collect(Collectors.toList());
    }

    public static boolean areEqual(ItemStack stack1, ItemStack stack2, boolean checkStackSize) {
        boolean equalItem;
        boolean bl = equalItem = stack1.func_77973_b() == stack2.func_77973_b();
        if (checkStackSize) {
            return equalItem && stack1.func_190916_E() == stack2.func_190916_E();
        }
        return equalItem;
    }

    private static /* synthetic */ ItemStack lambda$smeltItems$0(int smeltingCost, ItemStack leftHandStack, int[] ticks, IWorld world, PlayerEntity player, ItemEntity entity) {
        ItemStack stack = entity.func_92059_d();
        int stackSize = stack.func_190916_E();
        int ticksToSmeltStack = stackSize * smeltingCost;
        while (leftHandStack.func_190916_E() > 0 && ticks[0] < ticksToSmeltStack) {
            ticks[0] = ticks[0] + ItemStackUtils.getBurnTicks(leftHandStack);
            leftHandStack.func_190917_f(-1);
        }
        ItemStack smeltingResult = ItemStackUtils.getSmeltingResultAsNewStack(stack, world);
        if (ticks[0] >= ticksToSmeltStack) {
            smeltingResult.func_190920_e(stack.func_190916_E());
            entity.func_70106_y();
        } else if (ticks[0] >= smeltingCost) {
            int howManyCanSmelt = ticks[0] / smeltingCost;
            stack.func_190917_f(-howManyCanSmelt);
            smeltingResult.func_190920_e(howManyCanSmelt);
        } else {
            return ItemStack.field_190927_a;
        }
        ticks[0] = ticks[0] - ticksToSmeltStack;
        player.field_71106_cc += ItemStackUtils.getExperienceFromStack(stack, world);
        entity.func_70106_y();
        return smeltingResult;
    }
}

