/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.utils;

import com.github.sejoslaw.vanillamagic2.common.functions.Consumer3;
import com.github.sejoslaw.vanillamagic2.common.utils.WorldUtils;
import java.util.stream.StreamSupport;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;

public final class NbtUtils {
    public static final String NBT_ENTITY_TYPE = "NBT_ENTITY_TYPE";
    public static final String NBT_ENTITY_NAME = "NBT_ENTITY_NAME";
    public static final String NBT_BLOCK = "NBT_BLOCK";
    public static final String NBT_BLOCK_STATE = "NBT_BLOCK_STATE";
    public static final String NBT_TILE_TYPE = "NBT_TILE_TYPE";
    public static final String NBT_POSITION = "NBT_POSITION";
    public static final String NBT_DIMENSION = "NBT_DIMENSION";
    public static final String NBT_VM_ITEM_UNIQUE_NAME = "NBT_VM_ITEM_UNIQUE_NAME";
    public static final String NBT_SPAWNER_ENTITY = "NBT_SPAWNER_ENTITY";
    public static final String NBT_CAPTURED = "NBT_CAPTURED";
    public static final String NBT_SPELL_ID = "NBT_SPELL_ID";
    public static final String NBT_TICKS = "NBT_TICKS";
    public static final String NBT_MACHINE_MODULE_KEY = "NBT_MACHINE_MODULE_KEY";
    public static final String NBT_MODULE_START_POS = "NBT_MODULE_START_POS";
    public static final String NBT_MODULE_WORKING_POS = "NBT_MODULE_WORKING_POS";
    public static final String NBT_MODULE_STORAGE_INPUT_POS = "NBT_MODULE_STORAGE_INPUT_POS";
    public static final String NBT_MODULE_STORAGE_OUTPUT_POS = "NBT_MODULE_STORAGE_OUTPUT_POS";
    public static final String NBT_MODULE_ENERGY_LEVEL = "NBT_MODULE_ENERGY_LEVEL";
    public static final String NBT_MODULE_ENERGY_SOURCE_POS = "NBT_MODULE_ENERGY_SOURCE_POS";
    public static final CompoundNBT EMPTY_NBT = new CompoundNBT();

    public static CompoundNBT toNbt(IWorld world, BlockPos pos) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74772_a(NBT_POSITION, pos.func_218275_a());
        nbt.func_74778_a(NBT_DIMENSION, WorldUtils.getId(world).toString());
        return nbt;
    }

    public static BlockPos getPos(CompoundNBT nbt) {
        return BlockPos.func_218283_e((long)nbt.func_74763_f(NBT_POSITION));
    }

    public static ServerWorld getWorld(MinecraftServer server, CompoundNBT nbt) {
        String dimId = nbt.func_74779_i(NBT_DIMENSION);
        return StreamSupport.stream(server.func_212370_w().spliterator(), false).filter(world -> world.func_234923_W_().getRegistryName().equals((Object)dimId)).findFirst().orElse(null);
    }

    public static void forEachEntry(INBT nbt, Consumer3<Integer, String, String> consumer) {
        NbtUtils.forEachEntry("NBT", nbt, 0, consumer);
    }

    private static void forEachEntry(String parentKey, INBT nbt, int depth, Consumer3<Integer, String, String> consumer) {
        if (nbt instanceof CompoundNBT) {
            NbtUtils.handleNbtEntry(parentKey, (INBT)EMPTY_NBT, depth, consumer);
            for (String key : ((CompoundNBT)nbt).func_150296_c()) {
                INBT valueTag = ((CompoundNBT)nbt).func_74781_a(key);
                NbtUtils.forEachEntry(key, valueTag, depth + 1, consumer);
            }
        } else if (nbt instanceof ListNBT) {
            NbtUtils.handleNbtEntry(parentKey, (INBT)EMPTY_NBT, depth, consumer);
            for (int i = 0; i < ((ListNBT)nbt).size(); ++i) {
                INBT valueTag = ((ListNBT)nbt).get(i);
                NbtUtils.forEachEntry(String.valueOf(i), valueTag, depth + 1, consumer);
            }
        } else {
            NbtUtils.handleNbtEntry(parentKey, nbt, depth, consumer);
        }
    }

    private static void handleNbtEntry(String key, INBT nbt, int depth, Consumer3<Integer, String, String> consumer) {
        ITextComponent str = nbt.func_197637_c();
        consumer.accept(depth, key, str.getString());
    }
}

