/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.utils;

import com.github.sejoslaw.vanillamagic2.common.utils.WorldUtils;
import com.github.sejoslaw.vanillamagic2.core.VMEvents;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;

public final class TextUtils {
    public static String getFormattedText(String key) {
        return TextUtils.getFormattedText(TextUtils.translate(key));
    }

    public static String getFormattedText(ITextComponent comp) {
        return comp.getString();
    }

    public static ITextComponent translate(String key) {
        return new TranslationTextComponent(key);
    }

    public static void addChatMessage(String key) {
        TextUtils.addChatMessage(TextUtils.translate(key));
    }

    public static void addChatMessage(ITextComponent message) {
        if (VMEvents.isClient()) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a(message);
        }
    }

    public static ITextComponent toComponent(String message) {
        return new StringTextComponent(message);
    }

    public static ITextComponent combine(ITextComponent component, String text) {
        return TextUtils.toComponent(TextUtils.getFormattedText(component) + text);
    }

    public static String getPosition(IWorld world, BlockPos pos) {
        return WorldUtils.getId(world).toString() + "[" + pos.toString() + "]";
    }

    public static void addLine(List<ITextComponent> lines, String key, String value) {
        lines.add(TextUtils.toComponent(TextUtils.buildMessageLine(key, value)));
    }

    public static String firstLetterToUpper(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String buildMessageLine(String key, String value) {
        return TextFormatting.GREEN + TextUtils.getFormattedText(key) + TextFormatting.WHITE + " " + value;
    }
}

