/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.utils;

import com.github.sejoslaw.vanillamagic2.common.tileentities.IVMTileEntity;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerWorldInfo;

public final class WorldUtils {
    public static String WORLD_NAME = "";

    public static void forServer(IWorld world, Consumer<IServerWorld> consumer) {
        if (!(world instanceof IServerWorld)) {
            return;
        }
        consumer.accept((IServerWorld)world);
    }

    public static <T extends Entity> List<T> getEntities(IWorld world, Class<T> clazz, BlockPos pos, double offset, Predicate<T> check) {
        AxisAlignedBB aabb = new AxisAlignedBB(pos).func_72321_a(offset, offset, offset).func_72321_a(-offset, -offset, -offset);
        return world.func_175647_a(clazz, aabb, check);
    }

    public static List<ItemEntity> getItems(IWorld world, BlockPos pos) {
        return WorldUtils.getEntities(world, ItemEntity.class, pos, 1.0, Entity::func_70089_S);
    }

    public static List<ItemEntity> getOres(IWorld world, BlockPos pos) {
        return WorldUtils.getItems(world, pos).stream().filter(entity -> entity.func_92059_d().func_77973_b().getRegistryName().toString().toLowerCase().contains("ore")).collect(Collectors.toList());
    }

    public static void spawnOnCauldron(IWorld world, BlockPos pos, List<ItemStack> stacks, Function<ItemStack, Integer> stackCountModifier) {
        BlockPos spawnPos = pos.func_177972_a(Direction.UP);
        stacks.forEach(stack -> {
            stack.func_190920_e(((Integer)stackCountModifier.apply((ItemStack)stack)).intValue());
            Block.func_180635_a((World)WorldUtils.asWorld(world), (BlockPos)spawnPos, (ItemStack)stack);
        });
    }

    public static <TVMTileEntity extends IVMTileEntity> void spawnVMTile(IWorld world, BlockPos pos, TVMTileEntity tile, Consumer<TVMTileEntity> consumer) {
        if (WorldUtils.getIsRemote(world) || WorldUtils.getTickableTileEntities(world).stream().anyMatch(tileEntity -> tileEntity.func_174877_v().equals((Object)pos))) {
            return;
        }
        tile.initialize(world, pos);
        consumer.accept(tile);
        tile.spawn();
    }

    public static void tick(IWorld world, BlockPos pos, int ticks, Random rand) {
        if (WorldUtils.getIsRemote(world)) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        boolean isTickable = tile instanceof ITickableTileEntity;
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        for (int i = 0; i < ticks; ++i) {
            if (isTickable) {
                ((ITickableTileEntity)tile).func_73660_a();
                continue;
            }
            if (!(world instanceof ServerWorld)) continue;
            block.func_225534_a_(state, (ServerWorld)world, pos, rand);
        }
    }

    public static IInventory getInventory(IWorld world, BlockPos pos) {
        return HopperTileEntity.func_195484_a((World)WorldUtils.asWorld(world), (BlockPos)pos);
    }

    public static IVMTileEntity getVMTile(IWorld world, BlockPos pos) {
        return WorldUtils.getVMTiles(world, vmTile -> vmTile.getPos().equals((Object)pos)).stream().findFirst().orElse(null);
    }

    public static List<IVMTileEntity> getVMTiles(IWorld world, Predicate<IVMTileEntity> check) {
        return WorldUtils.getTickableTileEntities(world).stream().filter(tile -> tile instanceof IVMTileEntity && check.test((IVMTileEntity)tile)).map(tile -> (IVMTileEntity)tile).collect(Collectors.toList());
    }

    public static String getWorldName(IWorld world) {
        if (world instanceof ServerWorld) {
            WORLD_NAME = ((IServerWorldInfo)world.func_72912_H()).func_76065_j();
        }
        return WORLD_NAME;
    }

    public static void putStacksInInventoryAllSlots(IWorld world, IInventory outputInv, List<ItemStack> stacks, Direction direction, BlockPos spawnPos) {
        stacks.forEach(stack -> {
            if (stack.func_77973_b() == Items.field_190931_a || stack.func_190916_E() <= 0) {
                return;
            }
            if (outputInv == null) {
                Block.func_180635_a((World)WorldUtils.asWorld(world), (BlockPos)spawnPos, (ItemStack)stack);
            } else {
                ItemStack leftStack = HopperTileEntity.func_174918_a(null, (IInventory)outputInv, (ItemStack)stack, (Direction)direction);
                if (leftStack != ItemStack.field_190927_a && leftStack.func_190916_E() > 0) {
                    Block.func_180635_a((World)WorldUtils.asWorld(world), (BlockPos)spawnPos, (ItemStack)leftStack);
                }
            }
        });
    }

    public static ResourceLocation getId(IWorld world) {
        return WorldUtils.asWorld(world).func_234923_W_().func_240901_a_();
    }

    public static boolean getIsRemote(IWorld world) {
        return WorldUtils.asWorld((IWorld)world).field_72995_K;
    }

    public static List<TileEntity> getTickableTileEntities(IWorld world) {
        return WorldUtils.asWorld((IWorld)world).field_175730_i;
    }

    public static World asWorld(IWorld world) {
        return (World)world;
    }
}

