/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.core;

import com.github.sejoslaw.vanillamagic2.common.files.VMForgeConfig;
import com.github.sejoslaw.vanillamagic2.common.functions.Consumer4;
import com.github.sejoslaw.vanillamagic2.common.handlers.core.PlayerQuestProgressLoadHandler;
import com.github.sejoslaw.vanillamagic2.common.handlers.core.PlayerQuestProgressSaveHandler;
import com.github.sejoslaw.vanillamagic2.common.handlers.core.VMTileEntityLoadHandler;
import com.github.sejoslaw.vanillamagic2.common.handlers.core.VMTileEntitySaveHandler;
import com.github.sejoslaw.vanillamagic2.common.json.IJsonService;
import com.github.sejoslaw.vanillamagic2.common.json.JsonService;
import com.github.sejoslaw.vanillamagic2.common.utils.EntityUtils;
import com.github.sejoslaw.vanillamagic2.common.utils.WorldUtils;
import com.github.sejoslaw.vanillamagic2.core.VMEvents;
import com.github.sejoslaw.vanillamagic2.core.VMLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.IWorld;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public final class VMFiles {
    public static void initialize() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, VMForgeConfig.COMMON_CONFIG, "VanillaMagicConfig.toml");
        VMFiles.unzip(VMFiles.getQuestsFilePath().toFile(), VMFiles.getQuestsFileSourcePath().toFile());
        VMEvents.register(new VMTileEntitySaveHandler());
        VMEvents.register(new VMTileEntityLoadHandler());
        VMEvents.register(new PlayerQuestProgressSaveHandler());
        VMEvents.register(new PlayerQuestProgressLoadHandler());
    }

    public static String getQuestsFileName() {
        return "VanillaMagicQuests.json";
    }

    public static Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    public static Path getQuestsFilePath() {
        return Paths.get(FMLPaths.CONFIGDIR.get().toString(), VMFiles.getQuestsFileName());
    }

    public static Path getVMWorldDir(String worldName) {
        String path = VMFiles.getGameDir().toString();
        if (VMEvents.isClient()) {
            path = Paths.get(path, "saves").toString();
        }
        return Paths.get(path, worldName, "VanillaMagic");
    }

    public static Path getVMTileEntitiesFilePath(IWorld world) {
        String worldName = WorldUtils.getWorldName(world);
        String dimensionId = WorldUtils.getId(world).func_110623_a();
        return Paths.get(VMFiles.getVMWorldDir(worldName).toString(), dimensionId, "VanillaMagicTileEntities.dat");
    }

    public static void parsePlayerQuests(PlayerEntity player, Consumer4<PlayerEntity, String, String, File> consumer) {
        String playerName = EntityUtils.getPlayerNameFormatted(player);
        String worldName = WorldUtils.getWorldName((IWorld)player.func_130014_f_());
        Path playerQuestsPath = VMFiles.getPlayerQuestsFilePath(worldName, playerName);
        File playerQuestsFile = playerQuestsPath.toFile();
        consumer.accept(player, worldName, playerName, playerQuestsFile);
    }

    public static Path getPlayerQuestsFilePath(String worldName, String playerName) {
        return Paths.get(VMFiles.getVMWorldDir(worldName).toString(), "players_quests", playerName + ".json");
    }

    public static Path getQuestsFileSourcePath() {
        Path modsPath = FMLPaths.MODSDIR.get();
        File modsFile = modsPath.toFile();
        if (modsFile.exists()) {
            for (String modFilePath : modsFile.list()) {
                if (!modFilePath.toLowerCase().startsWith("vanillamagic2")) continue;
                return Paths.get(modsPath.toString(), modFilePath);
            }
        }
        return Paths.get(modsPath.getParent().getParent().toString(), "src", "main", "resources", VMFiles.getQuestsFileName());
    }

    public static void unzip(File destinationFile, File sourceFile) {
        if (destinationFile.exists()) {
            return;
        }
        try {
            destinationFile.createNewFile();
            InputStream is = null;
            FileOutputStream fos = null;
            if (sourceFile.getName().endsWith("jar")) {
                JarFile jarFile = new JarFile(sourceFile);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry file = enumeration.nextElement();
                    if (!file.getName().equals(VMFiles.getQuestsFileName())) continue;
                    is = jarFile.getInputStream(file);
                    fos = new FileOutputStream(destinationFile);
                    break;
                }
            } else {
                is = new FileInputStream(sourceFile);
                fos = new FileOutputStream(destinationFile);
            }
            if (is == null) {
                throw new FileNotFoundException(destinationFile.getName() + "file not found or is corrupted. Destination path: " + destinationFile.getAbsolutePath() + "; Source path: " + sourceFile.getAbsolutePath());
            }
            while (((InputStream)is).available() > 0) {
                fos.write(((InputStream)is).read());
            }
            fos.close();
            ((InputStream)is).close();
            VMLogger.logInfo(destinationFile.getName() + " created.");
        }
        catch (Exception e) {
            e.printStackTrace();
            VMLogger.logInfo("Error while creating file: " + destinationFile.getName());
        }
    }

    public static void readJsonArray(File file, Consumer<IJsonService> consumer) {
        VMFiles.readJsonInternal(file, reader -> JsonService.parseArray(reader, consumer));
    }

    public static void readJson(File file, Consumer<IJsonService> consumer) {
        VMFiles.readJsonInternal(file, reader -> JsonService.parse(reader, consumer));
    }

    public static void writeJson(File file, Consumer<OutputStreamWriter> consumer) {
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter osw = new OutputStreamWriter(fos);
            consumer.accept(osw);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void readJsonInternal(File file, Consumer<InputStreamReader> consumer) {
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader reader = new InputStreamReader(fis);
            consumer.accept(reader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

