/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.gman;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JINIFile
extends ArrayList<String> {
    private final File userFileName;

    public JINIFile(File file) throws IOException {
        block3: {
            this.clear();
            this.userFileName = file;
            if (this.userFileName.exists()) {
                BufferedReader inbuf = new BufferedReader(new FileReader(this.userFileName));
                while (true) {
                    String s;
                    if ((s = inbuf.readLine()) == null) {
                        inbuf.close();
                        break block3;
                    }
                    if (s.startsWith(";")) continue;
                    this.add(s);
                }
            }
            file.createNewFile();
            BufferedReader inbuf = new BufferedReader(new FileReader(this.userFileName));
            inbuf.close();
        }
    }

    private void addToList(String Section, String key, String value) {
        if (this.SectionExist(Section)) {
            if (this.ValueExist(Section, key)) {
                int pos = this.ValuePosition(Section, key);
                this.remove(pos);
                this.add(pos, value);
            } else {
                this.add(this.SectionPosition(Section) + 1, value);
            }
        } else {
            this.add("[" + Section + "]");
            this.add(value);
        }
    }

    public void DeleteKey(String Section, String key) {
        if (this.ValuePosition(Section, key) > 0) {
            this.remove(this.ValuePosition(Section, key));
        }
    }

    public void EraseSection(String Section) {
        int start = this.SectionPosition(Section) + 1;
        if (this.SectionPosition(Section) > -1) {
            String s;
            for (int i = start; !(i >= this.size() || (s = (String)this.get(i)).startsWith("[") && s.endsWith("]")); ++i) {
                this.remove(i);
                --i;
            }
            this.remove(this.SectionPosition(Section));
        }
    }

    public boolean ReadBool(String Section, String key, boolean defaultValue) throws JINIReadException {
        String s = ((String)this.get(this.ValuePosition(Section, key))).substring(key.length() + 1);
        if (this.ValuePosition(Section, key) > 0) {
            return Boolean.parseBoolean(s);
        }
        throw new JINIReadException("ReadBool operation failed: " + s);
    }

    public Float ReadFloat(String Section, String key, Float defaultValue) throws JINIReadException {
        new Float(0.0f);
        if (this.ValuePosition(Section, key) > 0) {
            int strLen = key.length() + 1;
            return Float.valueOf(((String)this.get(this.ValuePosition(Section, key))).substring(strLen));
        }
        throw new JINIReadException("ReadFloat operation failed.");
    }

    public int ReadInteger(String Section, String key, int defaultValue) throws JINIReadException {
        if (this.ValuePosition(Section, key) > 0) {
            int strLen = key.length() + 1;
            return Integer.parseInt(((String)this.get(this.ValuePosition(Section, key))).substring(strLen));
        }
        throw new JINIReadException("ReadInteger operation failed.");
    }

    public List<String> ReadSection(String Section) {
        ArrayList<String> myList = new ArrayList<String>();
        int start = this.SectionPosition(Section) + 1;
        if (this.SectionPosition(Section) > -1) {
            String s;
            for (int i = start; !(i >= this.size() || (s = (String)this.get(i)).startsWith("[") && s.endsWith("]")); ++i) {
                myList.add(s.substring(0, s.indexOf("=")));
            }
        }
        return myList;
    }

    public List<String> ReadSections() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.size(); ++i) {
            String s = (String)this.get(i);
            if (!s.startsWith("[") || !s.endsWith("]")) continue;
            list.add(s.substring(1, s.length() - 1));
        }
        return list;
    }

    public List<String> ReadSectionValues(String Section) {
        ArrayList<String> myList = new ArrayList<String>();
        int start = this.SectionPosition(Section) + 1;
        if (this.SectionPosition(Section) > -1) {
            String s;
            for (int i = start; !(i >= this.size() || (s = ((String)this.get(i)).substring(((String)this.get(i)).indexOf("=") + 1)).startsWith("[") && s.endsWith("]")); ++i) {
                myList.add(s);
            }
        }
        return myList;
    }

    public String ReadString(String Section, String key, String defaultValue) {
        String value = defaultValue;
        if (this.ValuePosition(Section, key) > 0) {
            int e = key.length() + 1;
            value = ((String)this.get(this.ValuePosition(Section, key))).substring(e);
        } else {
            try {
                throw new Exception("Failed to parse");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    private boolean SectionExist(String Section) {
        boolean val = false;
        for (String s : this) {
            if (!s.equals("[" + Section + "]")) continue;
            val = true;
            break;
        }
        return val;
    }

    private int SectionPosition(String Section) {
        int pos = -1;
        for (int i = 0; i < this.size(); ++i) {
            String s = (String)this.get(i);
            if (!s.equals("[" + Section + "]")) continue;
            pos = i;
            break;
        }
        return pos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean UpdateFile() {
        try (BufferedWriter ioe = new BufferedWriter(new FileWriter(this.userFileName, false));){
            String s;
            Iterator iterator = this.iterator();
            while (iterator.hasNext() && (s = (String)iterator.next()) != null) {
                ioe.write(s);
                ioe.newLine();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean ValueExist(String Section, String key) {
        int start = this.SectionPosition(Section);
        boolean val = false;
        for (int i = start + 1; i < this.size(); ++i) {
            String s = (String)this.get(i);
            if (s.startsWith(key + "=")) {
                val = true;
                break;
            }
            if (s.startsWith("[") && s.endsWith("]")) break;
        }
        return val;
    }

    private int ValuePosition(String Section, String key) {
        int start = this.SectionPosition(Section);
        int pos = -1;
        for (int i = start + 1; i < this.size(); ++i) {
            String s = (String)this.get(i);
            if (s.startsWith(key + "=")) {
                pos = i;
                break;
            }
            if (s.startsWith("[") && s.endsWith("]")) break;
        }
        return pos;
    }

    public void WriteBool(String Section, String key, boolean value) {
        String s = key + "=" + value;
        this.addToList(Section, key, s);
    }

    public void WriteComment(String Section, String comment) {
        if (this.SectionExist(Section)) {
            this.add(this.SectionPosition(Section) + 1, "; " + comment);
        }
    }

    public void WriteFloat(String Section, String key, float value) {
        String s = key + "=" + value;
        this.addToList(Section, key, s);
    }

    public void WriteInteger(String Section, String key, int value) {
        String s = key + "=" + value;
        this.addToList(Section, key, s);
    }

    public void WriteString(String Section, String key, String value) {
        String s = key + "=" + value;
        this.addToList(Section, key, s);
    }

    public static class JINIReadException
    extends Exception {
        JINIReadException(String string) {
            super(string);
        }
    }
}

