/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.client.device;

import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import net.gliby.voicechat.VoiceChat;
import net.gliby.voicechat.client.device.Device;
import net.gliby.voicechat.client.sound.ClientStreamManager;

public class DeviceHandler {
    private final List<Device> devices = new ArrayList<Device>();

    public Device getDefaultDevice() {
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, ClientStreamManager.getUniversalAudioFormat());
        if (AudioSystem.isLineSupported(info)) {
            TargetDataLine line;
            try {
                line = (TargetDataLine)AudioSystem.getLine(info);
            }
            catch (Exception var4) {
                return null;
            }
            return line != null ? this.getDeviceByLine(line) : null;
        }
        return null;
    }

    private Device getDeviceByLine(TargetDataLine line) {
        return this.devices.stream().filter(device1 -> device1.getLine().getLineInfo().equals(line.getLineInfo())).findFirst().orElse(null);
    }

    public Device getDeviceByName(String deviceName) {
        return this.devices.stream().filter(device1 -> device1.getName().equals(deviceName)).findFirst().orElse(null);
    }

    public List<Device> getDevices() {
        return this.devices;
    }

    public boolean isEmpty() {
        return this.devices.isEmpty();
    }

    public List<Device> loadDevices() {
        Mixer.Info[] mixers;
        this.devices.clear();
        for (Mixer.Info info : mixers = AudioSystem.getMixerInfo()) {
            Mixer mixer = AudioSystem.getMixer(info);
            try {
                DataLine.Info e = new DataLine.Info(TargetDataLine.class, ClientStreamManager.getUniversalAudioFormat());
                TargetDataLine tdl = (TargetDataLine)mixer.getLine(e);
                if (info == null) continue;
                this.devices.add(new Device(tdl, info));
            }
            catch (IllegalArgumentException | LineUnavailableException e) {
                VoiceChat.getLogger().error("Line error: " + e.getMessage());
            }
        }
        return this.devices;
    }
}

