/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.client.gui.options;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.gliby.voicechat.client.VoiceChatClient;
import net.gliby.voicechat.client.device.Device;
import net.gliby.voicechat.client.gui.GuiBoostSlider;
import net.gliby.voicechat.client.gui.GuiCustomButton;
import net.gliby.voicechat.client.gui.GuiDropDownMenu;
import net.gliby.voicechat.client.keybindings.EnumBinding;
import net.gliby.voicechat.client.sound.MicrophoneTester;
import net.gliby.voicechat.client.textures.IndependentGUITexture;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.I18n;
import org.lwjgl.opengl.GL11;

public class GuiScreenOptionsWizard
extends GuiScreen {
    private final VoiceChatClient voiceChat;
    private final GuiScreen parent;
    private boolean dirty;
    private String[] textBatch;
    private GuiDropDownMenu dropDown;
    private final MicrophoneTester tester;
    private GuiCustomButton nextButton;
    private GuiCustomButton previousButton;
    private GuiCustomButton doneButton;
    private GuiBoostSlider boostSlider;
    private final Map<GuiButton, Integer> buttonMap = new HashMap<GuiButton, Integer>();
    private int currentPage = 1;
    private int lastPage = -1;
    private String title = "Voice Chat Setup Wizard.";
    private String text = "";

    public GuiScreenOptionsWizard(VoiceChatClient voiceChat, GuiScreen parent) {
        this.voiceChat = voiceChat;
        this.parent = parent;
        this.tester = new MicrophoneTester(voiceChat);
    }

    public void func_146284_a(GuiButton button) {
        if ((button == this.nextButton || button == this.previousButton || this.doneButton == button || this.buttonMap.get(button) != null && this.buttonMap.get(button) == this.currentPage) && !this.dropDown.dropDownMenu) {
            switch (button.field_146127_k) {
                case 0: {
                    if (this.currentPage >= 4) break;
                    ++this.currentPage;
                    break;
                }
                case 1: {
                    if (this.currentPage < 2) break;
                    --this.currentPage;
                    break;
                }
                case 2: {
                    if (this.currentPage != 4) break;
                    this.voiceChat.getSettings().setSetupNeeded(false);
                    this.field_146297_k.func_147108_a(null);
                    break;
                }
                case 3: {
                    this.voiceChat.getSettings().setSetupNeeded(false);
                    this.field_146297_k.func_147108_a(this.parent);
                }
            }
        }
    }

    private void drawPage(int mouseX, int mouseY, float partialTicks) {
        int centerW = this.field_146294_l / 2;
        int centerH = this.field_146295_m / 2;
        if (this.tester.recording && this.currentPage != 3) {
            this.tester.stop();
        }
        if (this.currentPage != 2 && this.dropDown.dropDownMenu) {
            this.dropDown.dropDownMenu = false;
        }
        if (!this.text.equals(this.textBatch[this.currentPage - 1])) {
            this.text = this.textBatch[this.currentPage - 1];
        }
        switch (this.currentPage) {
            case 1: {
                this.title = "Gliby's Voice Chat " + I18n.func_135052_a((String)"menu.setupWizard", (Object[])new Object[0]);
                break;
            }
            case 2: {
                this.title = I18n.func_135052_a((String)"menu.selectInputDevice", (Object[])new Object[0]);
                this.dropDown.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
                break;
            }
            case 3: {
                if (this.lastPage != this.currentPage) {
                    this.tester.start();
                }
                this.title = I18n.func_135052_a((String)"menu.adjustMicrophone", (Object[])new Object[0]);
                GL11.glPushMatrix();
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GL11.glDisable((int)3008);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glTranslatef((float)((float)centerW - 39.75f), (float)((float)centerH - 67.5f), (float)0.0f);
                GL11.glScalef((float)2.0f, (float)2.0f, (float)0.0f);
                IndependentGUITexture.GUI_WIZARD.bindTexture(this.field_146297_k);
                this.func_73729_b(0, 0, 0, 127, 35, 20);
                int progress = (int)this.tester.currentAmplitude;
                this.func_175174_a(3.35f, 0.0f, 35, 127, progress, 20);
                GL11.glEnable((int)3008);
                GL11.glPopMatrix();
                this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"menu.boostVoiceVolume", (Object[])new Object[0]), centerW, centerH - 26, -1);
                break;
            }
            case 4: {
                this.title = I18n.func_135052_a((String)"menu.finishWizard", (Object[])new Object[0]);
            }
        }
        this.lastPage = this.currentPage;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int centerW = this.field_146294_l / 2;
        int centerH = this.field_146295_m / 2;
        this.func_146276_q_();
        IndependentGUITexture.GUI_WIZARD.bindTexture(this.field_146297_k);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)centerW - 142.5f), (float)((float)centerH - 94.5f), (float)0.0f);
        GL11.glScalef((float)1.5f, (float)1.5f, (float)0.0f);
        this.func_73729_b(0, 0, 0, 0, 190, 127);
        GL11.glPopMatrix();
        this.func_73731_b(this.field_146297_k.field_71466_p, this.currentPage + "/" + 4, centerW + 108, centerH + 67, -1);
        if (this.title != null) {
            this.func_73731_b(this.field_146297_k.field_71466_p, ChatFormatting.BOLD + this.title, centerW - this.field_146297_k.field_71466_p.func_78256_a(this.title) / 2 - 12, centerH - 80, -1);
        }
        if (this.text != null) {
            this.field_146289_q.func_78279_b(ChatFormatting.stripFormatting((String)this.text), centerW - 107 - 1 + 1, centerH - 65 + 1, 230, 0);
            this.field_146289_q.func_78279_b(this.text, centerW - 107 - 1, centerH - 65, 230, -1);
        }
        for (GuiButton button : this.field_146292_n) {
            if (button != this.nextButton && button != this.previousButton && button != this.doneButton && (this.buttonMap.get(button) == null || this.buttonMap.get(button) != this.currentPage)) continue;
            button.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        }
        this.drawPage(mouseX, mouseY, partialTicks);
    }

    public void func_73866_w_() {
        List<Device> devices = this.voiceChat.getSettings().getDeviceHandler().getDevices();
        int size = devices.size();
        String[] array = new String[size];
        int centerW = this.field_146294_l / 2;
        int centerH = this.field_146295_m / 2;
        for (int i = 0; i < size; ++i) {
            array[i] = devices.get(i).getName();
        }
        this.dropDown = new GuiDropDownMenu(-1, centerW - 75, centerH - 55, 150, 20, this.voiceChat.getSettings().getInputDevice() != null ? this.voiceChat.getSettings().getInputDevice().getName() : "None", array);
        this.nextButton = new GuiCustomButton(0, centerW - 90, centerH + 60, 180, 20, I18n.func_135052_a((String)"menu.next", (Object[])new Object[0]) + " ->");
        this.field_146292_n.add(this.nextButton);
        this.previousButton = new GuiCustomButton(1, centerW - 90, centerH, 180, 20, "<- " + I18n.func_135052_a((String)"menu.previous", (Object[])new Object[0]));
        this.field_146292_n.add(this.previousButton);
        this.doneButton = new GuiCustomButton(2, centerW - 90, centerH, 180, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(this.doneButton);
        GuiCustomButton backButton = new GuiCustomButton(3, centerW - 90, centerH + 18, 180, 20, I18n.func_135052_a((String)"gui.back", (Object[])new Object[0]));
        this.field_146292_n.add(backButton);
        this.boostSlider = new GuiBoostSlider(900, centerW - 75, centerH - 15, "", I18n.func_135052_a((String)"menu.boost", (Object[])new Object[0]) + ": " + ((int)(this.voiceChat.getSettings().getInputBoost() * 5.0f) <= 0 ? I18n.func_135052_a((String)"options.off", (Object[])new Object[0]) : "" + (int)(this.voiceChat.getSettings().getInputBoost() * 5.0f) + "db"), 0.0f);
        this.field_146292_n.add(this.boostSlider);
        this.boostSlider.sliderValue = this.voiceChat.getSettings().getInputBoost();
        this.doneButton.field_146125_m = false;
        this.buttonMap.put(backButton, 1);
        this.buttonMap.put(this.boostSlider, 3);
        this.dirty = true;
        this.textBatch = new String[]{I18n.func_135052_a((String)"menu.setupWizardPageOne", (Object[])new Object[0]).replaceAll(Pattern.quote("$n"), "\n").replaceAll(Pattern.quote("$a"), this.voiceChat.keyManager.getKeyName(EnumBinding.OPEN_GUI_OPTIONS)), I18n.func_135052_a((String)"menu.setupWizardPageTwo", (Object[])new Object[0]).replaceAll(Pattern.quote("$n"), "\n"), I18n.func_135052_a((String)"menu.setupWizardPageThree", (Object[])new Object[0]).replaceAll(Pattern.quote("$n"), "\n"), I18n.func_135052_a((String)"menu.setupWizardPageFour", (Object[])new Object[0]).replaceAll(Pattern.quote("$n"), "\n").replaceAll(Pattern.quote("$a"), this.voiceChat.keyManager.getKeyName(EnumBinding.OPEN_GUI_OPTIONS)).replaceAll(Pattern.quote("$b"), this.voiceChat.keyManager.getKeyName(EnumBinding.SPEAK))};
    }

    public void func_73864_a(int x, int y, int b) throws IOException {
        if (this.currentPage == 2) {
            Device mic;
            if (this.dropDown.getMouseOverInteger() != -1 && this.dropDown.dropDownMenu && !this.voiceChat.getSettings().getDeviceHandler().isEmpty() && (mic = this.voiceChat.getSettings().getDeviceHandler().getDevices().get(this.dropDown.getMouseOverInteger())) != null) {
                this.voiceChat.getSettings().setInputDevice(mic);
                this.dropDown.setDisplayString(mic.getName());
            }
            if (this.dropDown.func_146116_c(this.field_146297_k, x, y) && b == 0) {
                this.dropDown.func_146113_a(this.field_146297_k.func_147118_V());
                boolean bl = this.dropDown.dropDownMenu = !this.dropDown.dropDownMenu;
            }
        }
        if (b == 0) {
            for (GuiButton button : this.field_146292_n) {
                if (button != this.nextButton && button != this.previousButton && this.doneButton != button && (this.buttonMap.get(button) == null || this.buttonMap.get(button) != this.currentPage) || !button.func_146116_c(this.field_146297_k, x, y)) continue;
                super.func_73864_a(x, y, b);
            }
        }
    }

    public void func_146281_b() {
        if (this.tester.recording) {
            this.tester.stop();
        }
        this.voiceChat.getSettings().getConfiguration().save();
    }

    public void func_73876_c() {
        float boost = this.voiceChat.getSettings().getInputBoost() * 5.0f;
        this.boostSlider.setDisplayString(I18n.func_135052_a((String)"menu.boost", (Object[])new Object[0]) + ": " + ((int)boost <= 0 ? I18n.func_135052_a((String)"options.off", (Object[])new Object[0]) : "" + (int)boost + "db"));
        this.voiceChat.getSettings().setInputBoost(this.boostSlider.sliderValue);
        if (this.lastPage != this.currentPage || this.dirty) {
            switch (this.currentPage) {
                case 1: 
                case 2: {
                    this.previousButton.field_146125_m = false;
                    this.doneButton.field_146125_m = false;
                    this.nextButton.field_146128_h = this.field_146294_l / 2 - 90;
                    this.nextButton.field_146129_i = this.field_146295_m / 2 + 60;
                    this.nextButton.func_175211_a(180);
                    this.nextButton.setHeight(20);
                    break;
                }
                case 4: {
                    this.nextButton.field_146125_m = false;
                    this.doneButton.field_146125_m = true;
                    this.doneButton.field_146128_h = this.field_146294_l / 2;
                    this.doneButton.field_146129_i = this.field_146295_m / 2 + 60;
                    this.doneButton.func_175211_a(95);
                    this.doneButton.setHeight(20);
                    this.previousButton.field_146128_h = this.field_146294_l / 2 - 95;
                    this.previousButton.field_146129_i = this.field_146295_m / 2 + 60;
                    this.previousButton.func_175211_a(95);
                    this.previousButton.setHeight(20);
                    break;
                }
                default: {
                    this.previousButton.field_146125_m = true;
                    this.nextButton.field_146125_m = true;
                    this.doneButton.field_146125_m = false;
                    this.nextButton.field_146128_h = this.field_146294_l / 2;
                    this.nextButton.field_146129_i = this.field_146295_m / 2 + 60;
                    this.nextButton.func_175211_a(95);
                    this.nextButton.setHeight(20);
                    this.previousButton.field_146128_h = this.field_146294_l / 2 - 95;
                    this.previousButton.field_146129_i = this.field_146295_m / 2 + 60;
                    this.previousButton.func_175211_a(95);
                    this.previousButton.setHeight(20);
                }
            }
            this.dirty = false;
        }
    }
}

