/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.client.gui.options;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.gliby.voicechat.client.VoiceChatClient;
import net.gliby.voicechat.client.device.Device;
import net.gliby.voicechat.client.gui.GuiBoostSlider;
import net.gliby.voicechat.client.gui.GuiCustomButton;
import net.gliby.voicechat.client.gui.GuiDropDownMenu;
import net.gliby.voicechat.client.gui.GuiScreenLocalMute;
import net.gliby.voicechat.client.gui.options.GuiScreenOptionsUI;
import net.gliby.voicechat.client.gui.options.GuiScreenOptionsWizard;
import net.gliby.voicechat.client.gui.options.GuiScreenVoiceChatOptionsAdvanced;
import net.gliby.voicechat.client.sound.MicrophoneTester;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;

public class GuiScreenVoiceChatOptions
extends GuiScreen {
    private final VoiceChatClient voiceChat;
    private final MicrophoneTester tester;
    private GuiCustomButton advancedOptions;
    private GuiCustomButton mutePlayer;
    private GuiBoostSlider boostSlider;
    private GuiBoostSlider voiceVolume;
    private GuiDropDownMenu dropDown;
    private GuiButton microphoneMode;
    private List<String> warningMessages;

    public GuiScreenVoiceChatOptions(VoiceChatClient voiceChat) {
        this.voiceChat = voiceChat;
        this.tester = new MicrophoneTester(voiceChat);
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                if (!(button instanceof GuiDropDownMenu) || this.voiceChat.getSettings().getDeviceHandler().isEmpty()) break;
                ((GuiDropDownMenu)button).dropDownMenu = !((GuiDropDownMenu)button).dropDownMenu;
                break;
            }
            case 2: {
                if (!this.tester.recording) {
                    this.tester.start();
                } else {
                    this.tester.stop();
                }
                button.field_146126_j = this.tester.recording ? I18n.func_135052_a((String)"menu.microphoneStopTest", (Object[])new Object[0]) : I18n.func_135052_a((String)"menu.microphoneTest", (Object[])new Object[0]);
                break;
            }
            case 3: {
                this.voiceChat.getSettings().getConfiguration().save();
                this.field_146297_k.func_147108_a(null);
                break;
            }
            case 4: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenOptionsUI(this.voiceChat, this));
                break;
            }
            case 5: {
                if (!this.dropDown.dropDownMenu) {
                    this.microphoneMode.field_146125_m = true;
                    this.microphoneMode.field_146124_l = true;
                    this.voiceChat.getSettings().setSpeakMode(this.voiceChat.getSettings().getSpeakMode() == 0 ? 1 : 0);
                    this.microphoneMode.field_146126_j = I18n.func_135052_a((String)"menu.speakMode", (Object[])new Object[0]) + ": " + (this.voiceChat.getSettings().getSpeakMode() == 0 ? I18n.func_135052_a((String)"menu.speakModePushToTalk", (Object[])new Object[0]) : I18n.func_135052_a((String)"menu.speakModeToggleToTalk", (Object[])new Object[0]));
                    break;
                }
                if (!this.voiceChat.getSettings().getDeviceHandler().isEmpty()) break;
                this.microphoneMode.field_146125_m = false;
                this.microphoneMode.field_146124_l = false;
                break;
            }
            case 10: {
                Sys.openURL((String)"https://www.patreon.com/ivasik78");
                break;
            }
            case 897: {
                if (this.dropDown.dropDownMenu) break;
                this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenLocalMute(this, this.voiceChat));
                break;
            }
            case 898: {
                if (this.dropDown.dropDownMenu) break;
                this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenOptionsWizard(this.voiceChat, this));
                break;
            }
            case 899: {
                if (this.dropDown.dropDownMenu) break;
                this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenVoiceChatOptionsAdvanced(this.voiceChat, this));
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int centerW = this.field_146294_l / 2;
        this.func_146276_q_();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)centerW - (float)(this.field_146289_q.func_78256_a("Voice Chat Options") / 2) * 1.5f), (float)0.0f, (float)0.0f);
        GL11.glScalef((float)1.5f, (float)1.5f, (float)0.0f);
        this.func_73731_b(this.field_146289_q, "Voice Chat Options", 0, 6, -1);
        GL11.glPopMatrix();
        for (int i = 0; i < this.warningMessages.size(); ++i) {
            int warnY = i * this.field_146289_q.field_78288_b + this.field_146295_m / 2 + 66 - this.field_146289_q.field_78288_b * this.warningMessages.size() / 2;
            this.func_73732_a(this.field_146289_q, this.warningMessages.get(i), centerW, warnY, -1);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private boolean inBounds(int mouseX, int mouseY, int x, int y, int w, int h) {
        return mouseX >= x && mouseY >= y && mouseX < x + w && mouseY < y + h;
    }

    public void func_73866_w_() {
        List<Device> devices = this.voiceChat.getSettings().getDeviceHandler().getDevices();
        int size = devices.size();
        int centerW = this.field_146294_l / 2;
        int centerH = this.field_146295_m / 2;
        String[] array = new String[size];
        for (int heightOffset = 0; heightOffset < size; ++heightOffset) {
            array[heightOffset] = devices.get(heightOffset).getName();
        }
        this.dropDown = new GuiDropDownMenu(0, centerW - 151, centerH - 55, 148, 20, this.voiceChat.getSettings().getInputDevice() != null ? this.voiceChat.getSettings().getInputDevice().getName() : "None", array);
        this.microphoneMode = new GuiButton(5, centerW - 152, centerH + 25 - 55, 150, 20, I18n.func_135052_a((String)"menu.speakMode", (Object[])new Object[0]) + ": " + (this.voiceChat.getSettings().getSpeakMode() == 0 ? I18n.func_135052_a((String)"menu.speakModePushToTalk", (Object[])new Object[0]) : I18n.func_135052_a((String)"menu.speakModeToggleToTalk", (Object[])new Object[0])));
        GuiButton UIPosition2 = new GuiButton(4, centerW + 2, centerH + 25 - 55, 150, 20, I18n.func_135052_a((String)"menu.uiOptions", (Object[])new Object[0]));
        this.voiceVolume = new GuiBoostSlider(910, centerW + 2, centerH - 25 - 55, "", I18n.func_135052_a((String)"menu.worldVolume", (Object[])new Object[0]) + ": " + (this.voiceChat.getSettings().getWorldVolume() == 0.0f ? I18n.func_135052_a((String)"options.off", (Object[])new Object[0]) : (int)(this.voiceChat.getSettings().getWorldVolume() * 100.0f) + "%"), 0.0f);
        this.voiceVolume.sliderValue = this.voiceChat.getSettings().getWorldVolume();
        this.boostSlider = new GuiBoostSlider(900, centerW + 2, centerH - 55, "", I18n.func_135052_a((String)"menu.boost", (Object[])new Object[0]) + ": " + ((int)(this.voiceChat.getSettings().getInputBoost() * 5.0f) <= 0 ? I18n.func_135052_a((String)"options.off", (Object[])new Object[0]) : "" + (int)(this.voiceChat.getSettings().getInputBoost() * 5.0f) + "db"), 0.0f);
        this.boostSlider.sliderValue = this.voiceChat.getSettings().getInputBoost();
        this.advancedOptions = new GuiCustomButton(899, centerW + 2, centerH + 49 - 55, 150, 20, I18n.func_135052_a((String)"menu.advancedOptions", (Object[])new Object[0]));
        this.field_146292_n.add(new GuiButton(2, centerW - 152, centerH - 25 - 55, 150, 20, !this.tester.recording ? I18n.func_135052_a((String)"menu.microphoneTest", (Object[])new Object[0]) : I18n.func_135052_a((String)"menu.microphoneStopTest", (Object[])new Object[0])));
        GuiButton returnToGame = new GuiButton(3, centerW - 75, this.field_146295_m - 34, 150, 20, I18n.func_135052_a((String)"menu.returnToGame", (Object[])new Object[0]));
        this.field_146292_n.add(returnToGame);
        this.field_146292_n.add(new GuiButton(10, centerW - 75, this.field_146295_m - 56, 150, 20, I18n.func_135052_a((String)"menu.gman.supportIvasik", (Object[])new Object[0])));
        this.field_146292_n.add(this.advancedOptions);
        this.field_146292_n.add(new GuiCustomButton(898, centerW - 152, centerH + 49 - 55, 150, 20, I18n.func_135052_a((String)"menu.openOptionsWizard", (Object[])new Object[0])));
        this.field_146292_n.add(UIPosition2);
        this.field_146292_n.add(this.microphoneMode);
        this.field_146292_n.add(this.boostSlider);
        this.field_146292_n.add(this.voiceVolume);
        this.mutePlayer = new GuiCustomButton(897, centerW - 152, centerH + 73 - 55, 304, 20, I18n.func_135052_a((String)"menu.mutePlayers", (Object[])new Object[0]));
        this.field_146292_n.add(this.mutePlayer);
        this.field_146292_n.add(this.dropDown);
        if (this.voiceChat.getSettings().getDeviceHandler().isEmpty()) {
            this.dropDown.field_146124_l = false;
            returnToGame.field_146124_l = false;
            this.boostSlider.field_146124_l = false;
            this.mutePlayer.field_146124_l = false;
            this.microphoneMode.field_146124_l = false;
            this.mutePlayer.field_146124_l = false;
        }
        super.func_73866_w_();
        this.warningMessages = new ArrayList<String>();
        if (this.voiceChat.getSettings().getDeviceHandler().isEmpty()) {
            this.warningMessages.add(ChatFormatting.DARK_RED + "No input devices found, add input device and restart Minecraft.");
        }
        if (this.field_146297_k.func_71356_B() || this.field_146297_k.field_71441_e == null) {
            this.warningMessages.add(ChatFormatting.RED + I18n.func_135052_a((String)"menu.warningSingleplayer", (Object[])new Object[0]));
        }
        if (!this.voiceChat.getClientNetwork().isConnected() && !this.field_146297_k.func_71356_B()) {
            this.warningMessages.add(ChatFormatting.RED + I18n.func_135052_a((String)"Server doesn't support voice chat.", (Object[])new Object[0]));
        }
    }

    public void func_73869_a(char character, int key) {
        if (key == 1) {
            this.voiceChat.getSettings().getConfiguration().save();
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int btn) throws IOException {
        if (btn == 0 && this.dropDown.getMouseOverInteger() != -1 && this.dropDown.dropDownMenu && !this.voiceChat.getSettings().getDeviceHandler().isEmpty()) {
            Device device = this.voiceChat.getSettings().getDeviceHandler().getDevices().get(this.dropDown.getMouseOverInteger());
            if (device == null) {
                return;
            }
            this.voiceChat.getSettings().setInputDevice(device);
            this.dropDown.setDisplayString(device.getName());
        }
        super.func_73864_a(mouseX, mouseY, btn);
    }

    public void func_146281_b() {
        if (this.tester.recording) {
            this.tester.stop();
        }
    }

    public void func_73876_c() {
        float boost = this.voiceChat.getSettings().getInputBoost() * 5.0f;
        float volume = this.voiceChat.getSettings().getWorldVolume();
        this.voiceChat.getSettings().setWorldVolume(this.voiceVolume.sliderValue);
        this.voiceChat.getSettings().setInputBoost(this.boostSlider.sliderValue);
        this.voiceVolume.setDisplayString(I18n.func_135052_a((String)"menu.worldVolume", (Object[])new Object[0]) + ": " + (volume == 0.0f ? I18n.func_135052_a((String)"options.off", (Object[])new Object[0]) : (int)(volume * 100.0f) + "%"));
        this.boostSlider.setDisplayString(I18n.func_135052_a((String)"menu.boost", (Object[])new Object[0]) + ": " + ((int)boost <= 0 ? I18n.func_135052_a((String)"options.off", (Object[])new Object[0]) : (int)boost + "db"));
        this.advancedOptions.allowed = !this.dropDown.dropDownMenu;
        this.mutePlayer.allowed = !this.dropDown.dropDownMenu;
    }
}

