/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.client.render;

import net.gliby.voicechat.client.VoiceChatClient;
import net.gliby.voicechat.client.sound.ClientStream;
import net.gliby.voicechat.client.textures.IndependentGUITexture;
import net.gliby.voicechat.common.MathUtility;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class RenderPlayerVoiceIcon
extends Gui {
    private final VoiceChatClient voiceChat;
    private final Minecraft mc;

    public RenderPlayerVoiceIcon(VoiceChatClient voiceChat, Minecraft mc) {
        this.voiceChat = voiceChat;
        this.mc = mc;
    }

    private void enableEntityLighting(Entity entity, float partialTicks) {
        int i1 = entity.func_70070_b();
        if (entity.func_70027_ad()) {
            i1 = 0xF000F0;
        }
        int j = i1 % 65536;
        int k = i1 / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)j / 1.0f), (float)((float)k / 1.0f));
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glEnable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    private void disableEntityLighting() {
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    @SubscribeEvent
    public void render(RenderWorldLastEvent event) {
        if (!VoiceChatClient.getSoundManager().currentStreams.isEmpty() && this.voiceChat.getSettings().isVoiceIconAllowed()) {
            GL11.glDisable((int)2929);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            this.translateWorld(this.mc, event.getPartialTicks());
            int i = 0;
            while ((float)i < MathUtility.clamp(VoiceChatClient.getSoundManager().currentStreams.size(), 0.0f, this.voiceChat.getSettings().getMaximumRenderableVoiceIcons())) {
                EntityLivingBase entity;
                ClientStream stream = VoiceChatClient.getSoundManager().currentStreams.get(i);
                if (stream.player.getPlayer() != null && stream.player.usesEntity && !(entity = (EntityLivingBase)stream.player.getPlayer()).func_82150_aj() && !this.mc.field_71474_y.field_74319_N) {
                    GL11.glPushMatrix();
                    this.enableEntityLighting((Entity)entity, event.getPartialTicks());
                    GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glDepthMask((boolean)false);
                    this.translateEntity((Entity)entity, event.getPartialTicks());
                    GL11.glRotatef((float)(-this.mc.func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)-0.25f, (float)(entity.field_70131_O + 0.7f), (float)0.0f);
                    GL11.glRotatef((float)this.mc.func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glScalef((float)0.015f, (float)0.015f, (float)1.0f);
                    IndependentGUITexture.TEXTURES.bindTexture(this.mc);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
                    if (!entity.func_70093_af()) {
                        this.renderIcon();
                    }
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glEnable((int)2929);
                    GL11.glDepthMask((boolean)true);
                    this.renderIcon();
                    IndependentGUITexture.bindPlayer(this.mc, (Entity)entity);
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)20.0f, (float)30.0f, (float)0.0f);
                    GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
                    GL11.glScalef((float)2.0f, (float)2.0f, (float)0.0f);
                    Gui.func_152125_a((int)0, (int)0, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)8, (int)8, (float)64.0f, (float)64.0f);
                    if (this.mc.field_71439_g != null && this.mc.field_71439_g.func_175148_a(EnumPlayerModelParts.HAT)) {
                        Gui.func_152125_a((int)0, (int)0, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)8, (int)8, (float)64.0f, (float)64.0f);
                    }
                    GL11.glPopMatrix();
                    this.disableEntityLighting();
                    GL11.glPopMatrix();
                }
                ++i;
            }
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2929);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderIcon() {
        this.func_73729_b(0, 0, 0, 0, 54, 46);
        switch ((int)((float)(Minecraft.func_71386_F() % 1000L) / 350.0f)) {
            case 0: {
                this.func_73729_b(12, -3, 0, 47, 22, 49);
                break;
            }
            case 1: {
                this.func_73729_b(31, -3, 23, 47, 14, 49);
                break;
            }
            case 2: {
                this.func_73729_b(40, -3, 38, 47, 16, 49);
            }
        }
    }

    private void translateEntity(Entity entity, float tick) {
        GL11.glTranslated((double)(entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)tick), (double)(entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)tick), (double)(entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)tick));
    }

    private void translateWorld(Minecraft mc, float tick) {
        GL11.glTranslated((double)(-(mc.field_71439_g.field_70169_q + (mc.field_71439_g.field_70165_t - mc.field_71439_g.field_70169_q) * (double)tick)), (double)(-(mc.field_71439_g.field_70167_r + (mc.field_71439_g.field_70163_u - mc.field_71439_g.field_70167_r) * (double)tick)), (double)(-(mc.field_71439_g.field_70166_s + (mc.field_71439_g.field_70161_v - mc.field_71439_g.field_70166_s) * (double)tick)));
    }
}

