/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.common.commands;

import java.util.List;
import javax.annotation.Nullable;
import net.gliby.voicechat.VoiceChat;
import net.gliby.voicechat.common.networking.ServerStream;
import net.gliby.voicechat.common.networking.ServerStreamManager;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class CommandChatMode
extends CommandBase {
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return args.length == 1 ? CommandChatMode.func_71530_a((String[])args, (String[])new String[]{"distance", "global", "world"}) : (args.length == 2 ? CommandChatMode.func_71530_a((String[])args, (String[])this.getListOfPlayerUsernames()) : null);
    }

    private String getChatMode(int chatMode) {
        return chatMode == 0 ? "distance" : (chatMode == 2 ? "global" : (chatMode == 1 ? "world" : "distance"));
    }

    private int getChatModeFromCommand(ICommandSender par1ICommandSender, String par2Str) {
        return !(par2Str.equalsIgnoreCase("distance") || par2Str.startsWith("d") || par2Str.equalsIgnoreCase("0")) ? (!(par2Str.equalsIgnoreCase("world") || par2Str.startsWith("w") || par2Str.equalsIgnoreCase("1")) ? (!(par2Str.equalsIgnoreCase("global") || par2Str.startsWith("g") || par2Str.equalsIgnoreCase("2")) ? 0 : 2) : 1) : 0;
    }

    public String func_71517_b() {
        return "vchatmode";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/vchatmode <mode> or /vchatmode <mode> [player]";
    }

    private String[] getListOfPlayerUsernames() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_72369_d();
    }

    public int func_82362_a() {
        return 3;
    }

    public boolean func_82358_a(String[] par1ArrayOfStr, int par2) {
        return par2 == 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws WrongUsageException, PlayerNotFoundException {
        if (args.length <= 0) throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        int chatMode = this.getChatModeFromCommand(sender, args[0]);
        EntityPlayerMP player = CommandChatMode.func_71521_c((ICommandSender)sender);
        if (player == null) throw new WrongUsageException("commands.generic.player.notFound", new Object[0]);
        ServerStreamManager dataManager = VoiceChat.getServerInstance().getServerNetwork().getDataManager();
        dataManager.chatModeMap.put(player.getPersistentID(), chatMode);
        ServerStream stream = dataManager.getStream(player.func_145782_y());
        if (stream != null) {
            stream.dirty = true;
        }
        if (player != sender) {
            CommandChatMode.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(player.func_70005_c_() + " set chat mode to " + this.getChatMode(chatMode).toUpperCase() + " (" + chatMode + ")"), (Object[])new Object[]{args[0]});
            return;
        } else {
            player.func_145747_a((ITextComponent)new TextComponentString("Set own chat mode to " + this.getChatMode(chatMode).toUpperCase() + " (" + chatMode + ")"));
            switch (chatMode) {
                case 0: {
                    player.func_145747_a((ITextComponent)new TextComponentString("Only players near you can hear you."));
                    return;
                }
                case 1: {
                    player.func_145747_a((ITextComponent)new TextComponentString("Every player in this world can hear you"));
                    return;
                }
                case 2: {
                    player.func_145747_a((ITextComponent)new TextComponentString("Every player can hear you."));
                }
            }
        }
    }
}

