/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.common.networking;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import net.gliby.voicechat.VoiceChat;
import net.gliby.voicechat.common.VoiceChatServer;
import net.gliby.voicechat.common.networking.ServerStreamManager;
import net.gliby.voicechat.common.networking.packets.MinecraftClientEntityDataPacket;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ServerNetwork {
    private final VoiceChatServer voiceChat;
    private String externalAddress;
    public final ServerStreamManager dataManager;

    public ServerNetwork(VoiceChatServer voiceChat) {
        this.voiceChat = voiceChat;
        this.dataManager = new ServerStreamManager(voiceChat);
    }

    public String getAddress() {
        return this.externalAddress;
    }

    public ServerStreamManager getDataManager() {
        return this.dataManager;
    }

    public String[] getPlayerIPs() {
        List players = FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().field_73010_i;
        String[] ips = new String[players.size()];
        for (int i = 0; i < players.size(); ++i) {
            EntityPlayerMP p = (EntityPlayerMP)players.get(i);
            ips[i] = p.func_71114_r();
        }
        return ips;
    }

    public EntityPlayerMP[] getPlayers() {
        List pl = FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().field_73010_i;
        return pl.toArray(new EntityPlayerMP[0]);
    }

    public void init() {
        if (this.voiceChat.getServerSettings().isUsingProxy()) {
            new Thread(() -> {
                this.externalAddress = this.retrieveExternalAddress();
            }, "Extrernal Address Retriver Process").start();
        }
        this.dataManager.init();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String retrieveExternalAddress() {
        VoiceChat.getLogger().info("Retrieving server address.");
        try (BufferedReader in = new BufferedReader(new InputStreamReader(new URL("http://checkip.amazonaws.com").openStream()));){
            String string = in.readLine();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "0.0.0.0";
        }
    }

    void sendEntityData(EntityPlayerMP player, int entityID, String username, double x, double y, double z) {
        VoiceChat.getDispatcher().sendTo((IMessage)new MinecraftClientEntityDataPacket(entityID, username, x, y, z), player);
    }

    public void stop() {
        this.dataManager.reset();
    }
}

