/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.common.networking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.gliby.voicechat.common.VoiceChatServer;
import net.gliby.voicechat.common.api.VoiceChatAPI;
import net.gliby.voicechat.common.api.events.ServerStreamEvent;
import net.gliby.voicechat.common.networking.ServerDatalet;
import net.gliby.voicechat.common.networking.ServerStream;
import net.gliby.voicechat.common.networking.ThreadDataQueue;
import net.gliby.voicechat.common.networking.ThreadDataUpdateStream;
import net.gliby.voicechat.common.networking.entityhandler.EntityHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ServerStreamManager {
    List<ServerStream> currentStreams;
    ConcurrentLinkedQueue<ServerDatalet> dataQueue;
    public ConcurrentHashMap<Integer, ServerStream> streaming;
    public HashMap<UUID, Integer> chatModeMap;
    private HashMap receivedEntityData;
    private Thread threadUpdate;
    private Thread treadQueue;
    private final VoiceChatServer voiceChat;
    public List<UUID> mutedPlayers;
    public EntityHandler entityHandler;
    volatile boolean running;

    ServerStreamManager(VoiceChatServer voiceChat) {
        this.voiceChat = voiceChat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueue(EntityPlayerMP player, byte[] decoded_data, byte divider, int id, boolean end) {
        if (!this.mutedPlayers.contains(player.getPersistentID())) {
            this.dataQueue.offer(new ServerDatalet(player, id, decoded_data, divider, end, -1));
            Thread thread = this.treadQueue;
            synchronized (thread) {
                this.treadQueue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStreamSafe(ServerStream stream) {
        this.streaming.put(stream.id, stream);
        this.currentStreams.add(stream);
        Thread thread = this.threadUpdate;
        synchronized (thread) {
            this.threadUpdate.notify();
        }
    }

    void createStream(ServerDatalet data) {
        ServerStream stream = new ServerStream(data.player, data.id, this.generateSource(data));
        this.addStreamSafe(stream);
        VoiceChatAPI.instance().bus().post((Event)new ServerStreamEvent.StreamCreated(this, stream, data));
        this.giveStream(stream, data);
    }

    void feedStreamToAllPlayers(ServerStream stream, ServerDatalet voiceData) {
        EntityPlayerMP speaker = voiceData.player;
        List players = speaker.field_70170_p.field_73010_i;
        if (voiceData.end) {
            for (EntityPlayer target : players) {
                if (target.func_145782_y() == speaker.func_145782_y()) continue;
                this.voiceChat.getVoiceServer().sendVoiceEnd((EntityPlayerMP)target, voiceData.id);
            }
        } else {
            for (EntityPlayer target : players) {
                if (target.func_145782_y() == speaker.func_145782_y()) continue;
                this.entityHandler.whileSpeaking(stream, speaker, (EntityPlayerMP)target);
                this.voiceChat.getVoiceServer().sendChunkVoiceData((EntityPlayerMP)target, voiceData.id, false, voiceData.data, voiceData.divider, voiceData.volume);
            }
        }
    }

    public void feedStreamToPlayer(ServerStream stream, ServerDatalet voiceData, EntityPlayerMP target, boolean direct) {
        EntityPlayerMP speaker = voiceData.player;
        if (voiceData.end) {
            if (target != null) {
                this.voiceChat.getVoiceServer().sendVoiceEnd(target, stream.id);
            }
        } else if (target != null) {
            this.entityHandler.whileSpeaking(stream, speaker, target);
            this.voiceChat.getVoiceServer().sendChunkVoiceData(target, voiceData.id, direct, voiceData.data, voiceData.divider, voiceData.volume);
        }
    }

    void feedStreamToWorld(ServerStream stream, ServerDatalet voiceData) {
        EntityPlayerMP speaker = voiceData.player;
        List players = speaker.field_70170_p.field_73010_i;
        if (voiceData.end) {
            for (EntityPlayer target : players) {
                if (target.func_145782_y() == speaker.func_145782_y() || this.voiceChat.getVoiceServer() == null) continue;
                this.voiceChat.getVoiceServer().sendVoiceEnd((EntityPlayerMP)target, stream.id);
            }
        } else {
            for (EntityPlayer target : players) {
                if (target.func_145782_y() == speaker.func_145782_y()) continue;
                this.entityHandler.whileSpeaking(stream, speaker, (EntityPlayerMP)target);
                this.voiceChat.getVoiceServer().sendChunkVoiceData((EntityPlayerMP)target, voiceData.id, false, voiceData.data, voiceData.divider, voiceData.volume);
            }
        }
    }

    void feedWithinEntityWithRadius(ServerStream stream, ServerDatalet voiceData, int distance) {
        EntityPlayerMP speaker = stream.player;
        List players = speaker.field_70170_p.field_73010_i;
        if (voiceData.end) {
            for (EntityPlayer target : players) {
                double distanceZ;
                double distanceY;
                double distanceX;
                if (target.func_145782_y() == speaker.func_145782_y() || !((distanceX = speaker.field_70165_t - target.field_70165_t) * distanceX + (distanceY = speaker.field_70163_u - target.field_70163_u) * distanceY + (distanceZ = speaker.field_70161_v - target.field_70161_v) * distanceZ < (double)(distance * distance)) || this.voiceChat.getVoiceServer() == null) continue;
                this.voiceChat.getVoiceServer().sendVoiceEnd((EntityPlayerMP)target, stream.id);
            }
        } else {
            for (EntityPlayer target : players) {
                double distanceZ;
                double distanceY;
                double distanceX;
                double distanceBetween;
                if (target.func_145782_y() == speaker.func_145782_y() || !((distanceBetween = (distanceX = speaker.field_70165_t - target.field_70165_t) * distanceX + (distanceY = speaker.field_70163_u - target.field_70163_u) * distanceY + (distanceZ = speaker.field_70161_v - target.field_70161_v) * distanceZ) < (double)(distance * distance))) continue;
                this.entityHandler.whileSpeaking(stream, speaker, (EntityPlayerMP)target);
                this.voiceChat.getVoiceServer().sendChunkVoiceData((EntityPlayerMP)target, voiceData.id, true, voiceData.data, voiceData.divider, voiceData.volume);
                if (stream.tick % this.voiceChat.serverSettings.positionUpdateRate == 0) {
                    if (distanceBetween > 4096.0) {
                        this.voiceChat.getVoiceServer().sendEntityPosition((EntityPlayerMP)target, speaker.func_145782_y(), speaker.field_70165_t, speaker.field_70163_u, speaker.field_70161_v);
                    }
                    stream.tick = 0;
                }
                ++stream.tick;
            }
        }
    }

    private String generateSource(ServerDatalet let) {
        return Integer.toString(let.id);
    }

    public ServerStream getStream(int entityId) {
        return this.streaming.get(entityId);
    }

    public void giveEntity(EntityPlayerMP receiver, EntityPlayerMP speaker) {
        this.voiceChat.getServerNetwork().sendEntityData(receiver, speaker.func_145782_y(), speaker.func_70005_c_(), speaker.field_70165_t, speaker.field_70163_u, speaker.field_70161_v);
    }

    void giveStream(ServerStream stream, ServerDatalet let) {
        VoiceChatAPI.instance().bus().post((Event)new ServerStreamEvent.StreamFeed(this, stream, let));
        stream.lastUpdated = System.currentTimeMillis();
        if (let.end) {
            this.killStream(stream);
        }
    }

    public void init() {
        this.running = true;
        this.entityHandler = new EntityHandler(this.voiceChat);
        this.mutedPlayers = new ArrayList<UUID>();
        this.dataQueue = new ConcurrentLinkedQueue();
        this.currentStreams = new ArrayList<ServerStream>();
        this.streaming = new ConcurrentHashMap();
        this.chatModeMap = new HashMap();
        this.receivedEntityData = new HashMap();
        this.treadQueue = new Thread((Runnable)new ThreadDataQueue(this), "Stream Queue");
        this.treadQueue.start();
        this.threadUpdate = new Thread((Runnable)new ThreadDataUpdateStream(this), "Stream Update");
        this.threadUpdate.start();
    }

    public void killStream(ServerStream stream) {
        this.currentStreams.remove(stream);
        this.streaming.remove(stream.id);
        VoiceChatAPI.instance().bus().post((Event)new ServerStreamEvent.StreamDestroyed(this, stream));
    }

    ServerStream newDatalet(ServerDatalet let) {
        return this.streaming.get(let.id);
    }

    void reset() {
        this.running = false;
        this.currentStreams.clear();
        this.chatModeMap.clear();
        this.dataQueue.clear();
        this.mutedPlayers.clear();
        this.receivedEntityData.clear();
        this.streaming.clear();
    }
}

