/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.common.networking.voiceservers.udp;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.gliby.voicechat.VoiceChat;
import net.gliby.voicechat.common.MathUtility;
import net.gliby.voicechat.common.networking.voiceservers.udp.UDPByteUtilities;
import net.gliby.voicechat.common.networking.voiceservers.udp.UDPClient;
import net.gliby.voicechat.common.networking.voiceservers.udp.UDPServerAuthenticationCompletePacket;
import net.gliby.voicechat.common.networking.voiceservers.udp.UDPVoiceServer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class UDPVoiceServerHandler {
    private final ExecutorService threadService;
    private final Map<InetSocketAddress, UDPClient> clientNetworkMap;
    private final UDPVoiceServer server;

    UDPVoiceServerHandler(UDPVoiceServer server) {
        this.server = server;
        this.threadService = Executors.newFixedThreadPool((int)MathUtility.clamp(FMLCommonHandler.instance().getMinecraftServerInstance().func_71275_y(), 1.0f, 10.0f));
        this.clientNetworkMap = new HashMap<InetSocketAddress, UDPClient>();
    }

    public void close() {
        this.clientNetworkMap.clear();
        this.threadService.shutdown();
    }

    void closeConnection(InetSocketAddress address) {
        this.clientNetworkMap.remove(address);
    }

    private void handleAuthetication(InetSocketAddress address, DatagramPacket packet, ByteArrayDataInput in) {
        String hash = new String(UDPByteUtilities.readBytes(in), StandardCharsets.UTF_8);
        EntityPlayerMP player = (EntityPlayerMP)this.server.waitingAuth.get(hash);
        if (player != null) {
            UDPClient client = new UDPClient(player, address, hash);
            this.clientNetworkMap.put(client.socketAddress, client);
            this.server.clientMap.put(player.func_145782_y(), client);
            this.server.waitingAuth.remove(hash);
            VoiceChat.getLogger().info(client + " has been authenticated by server.");
            this.server.sendPacket(new UDPServerAuthenticationCompletePacket(), client);
        }
    }

    private void handleVoice(UDPClient client, ByteArrayDataInput in) {
        this.server.handleVoiceData(client.player, UDPByteUtilities.readBytes(in), in.readByte(), client.player.func_145782_y(), false);
    }

    private void handleVoiceEnd(UDPClient client) {
        this.server.handleVoiceData(client.player, null, (byte)0, client.player.func_145782_y(), true);
    }

    public void read(byte[] data, DatagramPacket packet) {
        InetSocketAddress address = (InetSocketAddress)packet.getSocketAddress();
        UDPClient client = this.clientNetworkMap.get(address);
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
        byte id = in.readByte();
        this.threadService.execute(() -> {
            if (id == 0) {
                this.handleAuthetication(address, packet, in);
            }
            if (client != null) {
                switch (id) {
                    case 1: {
                        this.handleVoice(client, in);
                        break;
                    }
                    case 2: {
                        this.handleVoiceEnd(client);
                    }
                }
            }
        });
    }
}

