/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.world_blender.blocks;

import com.telepathicgrunt.world_blender.WBIdentifiers;
import com.telepathicgrunt.world_blender.blocks.WBBlocks;
import com.telepathicgrunt.world_blender.blocks.WBPortalBlockEntity;
import com.telepathicgrunt.world_blender.blocks.WBPortalSpawning;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public class WBPortalBlock
extends ContainerBlock {
    protected static final VoxelShape COLLISION_BOX = Block.func_208617_a((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);

    protected WBPortalBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151567_E, (MaterialColor)MaterialColor.field_151646_E).func_200942_a().func_235838_a_(blockState -> 6).func_200948_a(-1.0f, 3600000.0f).func_222380_e());
    }

    public TileEntity func_196283_a_(IBlockReader blockReader) {
        return new WBPortalBlockEntity();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return COLLISION_BOX;
    }

    public void func_196262_a(BlockState blockState, World world, BlockPos position, Entity entity) {
        TileEntity blockEntityOriginal = world.func_175625_s(position);
        if (blockEntityOriginal instanceof WBPortalBlockEntity) {
            WBPortalBlockEntity wbBlockEntity = (WBPortalBlockEntity)blockEntityOriginal;
            if (!world.func_201670_d() && !wbBlockEntity.isCoolingDown() && !entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU() && VoxelShapes.func_197879_c((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)entity.func_174813_aQ().func_72317_d((double)(-position.func_177958_n()), (double)(-position.func_177956_o()), (double)(-position.func_177952_p()))), (VoxelShape)COLLISION_BOX, (IBooleanFunction)IBooleanFunction.field_223238_i_)) {
                MinecraftServer minecraftServer = entity.func_184102_h();
                assert (minecraftServer != null);
                ServerWorld destinationWorld = minecraftServer.func_71218_a(world.func_234923_W_().equals(WBIdentifiers.WB_WORLD_KEY) ? World.field_234918_g_ : WBIdentifiers.WB_WORLD_KEY);
                ServerWorld originalWorld = minecraftServer.func_71218_a(entity.field_70170_p.func_234923_W_());
                if (destinationWorld == null) {
                    return;
                }
                BlockPos destPos = null;
                boolean portalOrChestFound = false;
                for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)position.func_177982_a(-4, -position.func_177956_o(), -4), (BlockPos)position.func_177982_a(4, 255 - position.func_177956_o(), 4))) {
                    TileEntity blockEntity;
                    Block blockNearTeleport = destinationWorld.func_180495_p(blockpos).func_177230_c();
                    if (blockNearTeleport == WBBlocks.WORLD_BLENDER_PORTAL.get()) {
                        if (destPos == null || Math.abs(blockpos.func_177958_n() - position.func_177958_n()) < Math.abs(destPos.func_177958_n() - position.func_177958_n()) && Math.abs(blockpos.func_177952_p() - position.func_177952_p()) < Math.abs(destPos.func_177952_p() - position.func_177952_p())) {
                            destPos = blockpos.func_185334_h();
                        }
                        portalOrChestFound = true;
                        blockEntity = destinationWorld.func_175625_s(blockpos);
                        if (!(blockEntity instanceof WBPortalBlockEntity)) continue;
                        ((WBPortalBlockEntity)blockEntity).triggerCooldown();
                        continue;
                    }
                    blockEntity = destinationWorld.func_175625_s(blockpos);
                    if (blockEntity == null || blockNearTeleport instanceof IInventory || !WBPortalSpawning.VALID_CHEST_BLOCKS_ENTITY_TYPES.getOrDefault((Object)blockEntity.func_200662_C(), false)) continue;
                    if (destPos == null) {
                        destPos = blockpos.func_185334_h();
                    }
                    portalOrChestFound = true;
                }
                if (!portalOrChestFound) {
                    destPos = destinationWorld.func_205770_a(Heightmap.Type.WORLD_SURFACE, position);
                    if (destinationWorld.func_234923_W_().equals(WBIdentifiers.WB_WORLD_KEY)) {
                        destinationWorld.func_175656_a(destPos, Blocks.field_150350_a.func_176223_P());
                        destinationWorld.func_175656_a(destPos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
                        destinationWorld.func_175656_a(destPos, ((Block)WBBlocks.WORLD_BLENDER_PORTAL.get()).func_176223_P());
                        TileEntity blockEntity = destinationWorld.func_175625_s(destPos);
                        if (blockEntity instanceof WBPortalBlockEntity) {
                            ((WBPortalBlockEntity)blockEntity).triggerCooldown();
                        }
                    }
                }
                wbBlockEntity.teleportEntity(entity, destPos, destinationWorld, originalWorld);
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult rayTrace) {
        TileEntity blockEntity = world.func_175625_s(blockPos);
        if (playerEntity.func_213453_ef() && blockEntity instanceof WBPortalBlockEntity && ((WBPortalBlockEntity)blockEntity).isRemoveable()) {
            if (world.func_201670_d()) {
                this.createLotsOfParticles(blockState, world, blockPos, world.field_73012_v);
            } else {
                world.func_175656_a(blockPos, Blocks.field_150350_a.func_176223_P());
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public void func_180655_c(BlockState blockState, World world, BlockPos position, Random random) {
        TileEntity TileEntity2 = world.func_175625_s(position);
        if (TileEntity2 instanceof WBPortalBlockEntity && random.nextFloat() < 0.09f) {
            this.spawnParticle(world, position, random);
        }
    }

    public void createLotsOfParticles(BlockState blockState, World world, BlockPos position, Random random) {
        TileEntity TileEntity2 = world.func_175625_s(position);
        if (TileEntity2 instanceof WBPortalBlockEntity) {
            for (int i = 0; i < 50; ++i) {
                this.spawnParticle(world, position, random);
            }
        }
    }

    private void spawnParticle(World world, BlockPos position, Random random) {
        double xPos = (double)position.func_177958_n() + (double)random.nextFloat();
        double yPos = (double)position.func_177956_o() + (double)random.nextFloat();
        double zPos = (double)position.func_177952_p() + (double)random.nextFloat();
        double xVelocity = ((double)random.nextFloat() - 0.5) * 0.08;
        double yVelocity = ((double)random.nextFloat() - 0.5) * 0.13;
        double zVelocity = ((double)random.nextFloat() - 0.5) * 0.08;
        world.func_195594_a((IParticleData)ParticleTypes.field_197624_q, xPos, yPos, zPos, xVelocity, yVelocity, zVelocity);
    }

    public ItemStack func_185473_a(IBlockReader p_185473_1_, BlockPos p_185473_2_, BlockState p_185473_3_) {
        return ItemStack.field_190927_a;
    }

    public boolean func_225541_a_(BlockState p_225541_1_, Fluid p_225541_2_) {
        return false;
    }
}

