/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.world_blender.blocks;

import com.telepathicgrunt.world_blender.WorldBlender;
import com.telepathicgrunt.world_blender.blocks.WBBlocks;
import com.telepathicgrunt.world_blender.blocks.WBPortalBlockEntity;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.Level;

public class WBPortalSpawning {
    protected static final Object2BooleanMap<TileEntityType<?>> VALID_CHEST_BLOCKS_ENTITY_TYPES = new Object2BooleanArrayMap();
    private static final List<Block> REQUIRED_PORTAL_BLOCKS = new ArrayList<Block>();
    private static final List<String> INVALID_IDS = new ArrayList<String>();

    public static void generateRequiredBlockList(IWorld world, String configEntry) {
        String[] entriesArray = configEntry.split(",");
        Arrays.parallelSetAll(entriesArray, i -> entriesArray[i].trim().toLowerCase(Locale.ROOT).replace(' ', '_'));
        for (String rlString : entriesArray) {
            if (rlString.isEmpty()) continue;
            if (Registry.field_212618_g.func_212607_c(new ResourceLocation(rlString))) {
                REQUIRED_PORTAL_BLOCKS.add((Block)Registry.field_212618_g.func_82594_a(new ResourceLocation(rlString)));
                continue;
            }
            INVALID_IDS.add(rlString);
        }
        for (Block block : Registry.field_212618_g) {
            if (!(block instanceof ContainerBlock)) continue;
            ResourceLocation blockId = Registry.field_212618_g.func_177774_c((Object)block);
            try {
                TileEntity blockEntity = ((ContainerBlock)block).func_196283_a_((IBlockReader)world);
                if (blockEntity == null) continue;
                ResourceLocation blockEntityId = Registry.field_212626_o.func_177774_c((Object)blockEntity.func_200662_C());
                if (blockEntityId != null) {
                    boolean hasChestName = blockId.func_110623_a().contains("chest") || blockEntityId.func_110623_a().contains("chest");
                    boolean isInventory = blockEntity instanceof IInventory;
                    VALID_CHEST_BLOCKS_ENTITY_TYPES.put((Object)blockEntity.func_200662_C(), hasChestName && isInventory);
                    continue;
                }
                throw new Exception();
            }
            catch (Throwable e) {
                WorldBlender.LOGGER.log(Level.WARN, "Failed to check if " + blockId + " is a chest. If is not a chest, ignore this message. If it is, let telepathicGrunt (World Blender dev) know this.");
            }
        }
    }

    public static void BlockRightClickEvent(PlayerInteractEvent.RightClickBlock event) {
        ActionResultType result = WBPortalSpawning.blockRightClick(event.getPlayer(), event.getWorld(), event.getHand(), event.getPos());
        if (!result.equals((Object)ActionResultType.PASS)) {
            event.setResult(Event.Result.DENY);
        }
    }

    public static ActionResultType blockRightClick(PlayerEntity player, World world, Hand hand, BlockPos position) {
        if (world.func_201670_d() || player.func_175149_v()) {
            return ActionResultType.PASS;
        }
        TileEntity blockEntity = world.func_175625_s(position);
        if (player.func_213453_ef() && blockEntity != null && VALID_CHEST_BLOCKS_ENTITY_TYPES.getOrDefault((Object)blockEntity.func_200662_C(), false)) {
            String[] activationItems = WorldBlender.WBPortalConfig.activationItem.get().split(",");
            Arrays.parallelSetAll(activationItems, i -> activationItems[i].trim().toLowerCase(Locale.ROOT).replace(' ', '_'));
            boolean validItem = false;
            for (String itemString : activationItems) {
                ResourceLocation activationItem = new ResourceLocation(itemString);
                if (!Registry.field_212630_s.func_241873_b(activationItem).isPresent()) {
                    WorldBlender.LOGGER.log(Level.INFO, "World Blender: Warning, the activation item set in the config does not exist. Please make sure " + itemString + " is a valid resource location to a real item as the portal cannot be created now.");
                    StringTextComponent message = new StringTextComponent(TextFormatting.YELLOW + "World Blender: " + TextFormatting.WHITE + "Warning, the activation item set in the config does not exist. Please make sure " + TextFormatting.YELLOW + itemString + TextFormatting.WHITE + " is a valid resource location to a real item as the portal cannot be created now.");
                    player.func_146105_b((ITextComponent)message, false);
                    return ActionResultType.FAIL;
                }
                if ((!player.func_184614_ca().func_77973_b().equals(Registry.field_212630_s.func_82594_a(activationItem)) || hand != Hand.MAIN_HAND) && (!player.func_184592_cb().func_77973_b().equals(Registry.field_212630_s.func_82594_a(activationItem)) || hand != Hand.OFF_HAND)) continue;
                validItem = true;
                break;
            }
            if (activationItems.length != 0 && !validItem) {
                return ActionResultType.PASS;
            }
            BlockPos.Mutable cornerOffset = new BlockPos.Mutable(1, 1, 1);
            boolean eightChestsFound = WBPortalSpawning.checkForValidChests(world, position, cornerOffset);
            if (eightChestsFound) {
                HashSet<Item> uniqueBlocksSet = new HashSet<Item>();
                HashSet<Item> invalidItemSet = new HashSet<Item>();
                HashSet<Item> duplicateBlockSlotSet = new HashSet<Item>();
                for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)position, (BlockPos)position.func_177971_a((Vector3i)cornerOffset))) {
                    TileEntity chestTileEntity = world.func_175625_s(blockpos);
                    if (chestTileEntity == null || !VALID_CHEST_BLOCKS_ENTITY_TYPES.getOrDefault((Object)blockEntity.func_200662_C(), false)) continue;
                    for (int index = 0; index < ((IInventory)chestTileEntity).func_70302_i_(); ++index) {
                        Item item2 = ((IInventory)chestTileEntity).func_70301_a(index).func_77973_b();
                        if (Block.func_149634_a((Item)item2) != Blocks.field_150350_a) {
                            if (uniqueBlocksSet.contains(item2)) {
                                duplicateBlockSlotSet.add(item2);
                            }
                            uniqueBlocksSet.add(item2);
                            continue;
                        }
                        invalidItemSet.add(item2);
                    }
                }
                if (!INVALID_IDS.isEmpty()) {
                    WorldBlender.LOGGER.log(Level.INFO, "World Blender: Warning, error reading the required blocks config entry. Please make sure the blocks specified in that config are valid resource locations and points to real blocks as the portal cannot be created now. The problematic entries are: " + String.join((CharSequence)", ", INVALID_IDS));
                    StringTextComponent message = new StringTextComponent(TextFormatting.YELLOW + "World Blender: " + TextFormatting.WHITE + "Warning, error reading the required blocks config entry. Please make sure the blocks specified in that config are valid resource locations and points to real blocks as the portal cannot be created now. The problematic entries are: " + TextFormatting.GOLD + String.join((CharSequence)", ", INVALID_IDS));
                    player.func_146105_b((ITextComponent)message, false);
                    return ActionResultType.FAIL;
                }
                ArrayList<Block> listOfRequireBlocksNotFound = new ArrayList<Block>(REQUIRED_PORTAL_BLOCKS);
                boolean isMissingRequiredBlocks = false;
                if (WorldBlender.WBPortalConfig.uniqueBlocksNeeded.get() <= REQUIRED_PORTAL_BLOCKS.size()) {
                    for (Item blockItem : uniqueBlocksSet) {
                        listOfRequireBlocksNotFound.remove(Block.func_149634_a((Item)blockItem));
                    }
                    if (WorldBlender.WBPortalConfig.uniqueBlocksNeeded.get() > REQUIRED_PORTAL_BLOCKS.size() - listOfRequireBlocksNotFound.size()) {
                        isMissingRequiredBlocks = true;
                    }
                } else {
                    for (Item blockItem : uniqueBlocksSet) {
                        listOfRequireBlocksNotFound.remove(Block.func_149634_a((Item)blockItem));
                    }
                    if (listOfRequireBlocksNotFound.size() != 0) {
                        isMissingRequiredBlocks = true;
                    }
                }
                if (isMissingRequiredBlocks) {
                    WorldBlender.LOGGER.log(Level.INFO, "World Blender: There are not enough required blocks in the chests. Please add the needed required blocks and then add any other unique blocks until you have " + WorldBlender.WBPortalConfig.uniqueBlocksNeeded.get() + " unique blocks. The require blocks specified in the config are " + REQUIRED_PORTAL_BLOCKS.stream().map(entry -> Registry.field_212618_g.func_177774_c(entry).toString()).collect(Collectors.joining(", ")));
                    StringTextComponent message = new StringTextComponent(TextFormatting.YELLOW + "World Blender: " + TextFormatting.WHITE + "There are not enough required blocks in the chests. Please add the needed required blocks and then add any other unique blocks until you have " + TextFormatting.RED + WorldBlender.WBPortalConfig.uniqueBlocksNeeded.get() + TextFormatting.WHITE + " unique blocks. The require blocks specified in the config are " + TextFormatting.GOLD + REQUIRED_PORTAL_BLOCKS.stream().map(entry -> Registry.field_212618_g.func_177774_c(entry).toString()).collect(Collectors.joining(", ")));
                    player.func_146105_b((ITextComponent)message, false);
                    return ActionResultType.FAIL;
                }
                invalidItemSet.remove(Items.field_190931_a);
                if (invalidItemSet.size() == 0 && uniqueBlocksSet.size() >= WorldBlender.WBPortalConfig.uniqueBlocksNeeded.get()) {
                    for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)position, (BlockPos)position.func_177971_a((Vector3i)cornerOffset))) {
                        if (WorldBlender.WBPortalConfig.consumeChests.get().booleanValue()) {
                            TileEntity chestTileEntity = world.func_175625_s(blockpos);
                            if (chestTileEntity != null && VALID_CHEST_BLOCKS_ENTITY_TYPES.getOrDefault((Object)blockEntity.func_200662_C(), false)) {
                                for (int index = ((IInventory)chestTileEntity).func_70302_i_(); index >= 0; --index) {
                                    ((IInventory)chestTileEntity).func_70304_b(index);
                                }
                            }
                        } else {
                            world.func_225521_a_(blockpos, true, (Entity)player);
                        }
                        world.func_180501_a(blockpos, ((Block)WBBlocks.WORLD_BLENDER_PORTAL.get()).func_176223_P(), 3);
                        WBPortalBlockEntity wbtile = (WBPortalBlockEntity)world.func_175625_s(blockpos);
                        if (wbtile != null) {
                            wbtile.triggerCooldown();
                        }
                        player.func_184607_cu().func_190918_g(1);
                    }
                    return ActionResultType.SUCCESS;
                }
                String msg = TextFormatting.YELLOW + "World Blender: " + TextFormatting.WHITE + "There are not enough unique block items in the chests. (stacks or duplicates are ignored) You need " + TextFormatting.RED + WorldBlender.WBPortalConfig.uniqueBlocksNeeded.get() + TextFormatting.WHITE + " block items to make the portal but there is only " + TextFormatting.GREEN + uniqueBlocksSet.size() + TextFormatting.WHITE + " unique block items right now.";
                if (invalidItemSet.size() > 0) {
                    ArrayList invalidItemString = new ArrayList();
                    invalidItemSet.forEach(item -> invalidItemString.add(item.func_200295_i(new ItemStack((IItemProvider)item)).getString()));
                    msg = msg + TextFormatting.WHITE + "\n Also, here is a list of non-block items that were found and should be removed: " + TextFormatting.GOLD + String.join((CharSequence)", ", invalidItemString);
                }
                if (duplicateBlockSlotSet.size() != 0) {
                    ArrayList duplicateSlotString = new ArrayList();
                    duplicateBlockSlotSet.remove(Items.field_190931_a);
                    duplicateBlockSlotSet.forEach(blockitem -> duplicateSlotString.add(blockitem.func_200295_i(new ItemStack((IItemProvider)blockitem)).getString()));
                    msg = msg + TextFormatting.WHITE + "\n There are some slots that contains the same blocks and should be removed. These blocks are: " + TextFormatting.GOLD + String.join((CharSequence)", ", duplicateSlotString);
                }
                WorldBlender.LOGGER.log(Level.INFO, msg);
                player.func_146105_b((ITextComponent)new StringTextComponent(msg), false);
                return ActionResultType.FAIL;
            }
        }
        return ActionResultType.PASS;
    }

    private static boolean checkForValidChests(World world, BlockPos position, BlockPos.Mutable offset) {
        boolean eightChestsFound = true;
        while (offset.func_177958_n() >= -1) {
            while (offset.func_177956_o() >= -1) {
                while (offset.func_177952_p() >= -1) {
                    for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)position, (BlockPos)position.func_177971_a((Vector3i)offset))) {
                        TileEntity blockEntity = world.func_175625_s(blockpos);
                        if (blockEntity != null && VALID_CHEST_BLOCKS_ENTITY_TYPES.getOrDefault((Object)blockEntity.func_200662_C(), false)) continue;
                        eightChestsFound = false;
                        break;
                    }
                    if (eightChestsFound) {
                        return true;
                    }
                    eightChestsFound = true;
                    offset.func_189534_c(Direction.NORTH, 2);
                }
                offset.func_189534_c(Direction.SOUTH, 4);
                offset.func_189534_c(Direction.DOWN, 2);
            }
            offset.func_189534_c(Direction.UP, 4);
            offset.func_189534_c(Direction.WEST, 2);
        }
        return false;
    }
}

