/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.world_blender.dimension;

import com.telepathicgrunt.world_blender.dimension.WBWorldSavedData;
import com.telepathicgrunt.world_blender.features.WBFeatures;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerWorld;

public class AltarManager {
    private boolean altarMade;
    private final ServerWorld world;

    public AltarManager(ServerWorld serverWorld) {
        this.world = serverWorld;
        this.altarMade = WBWorldSavedData.get((World)serverWorld).getWBAltarState();
    }

    public void tick() {
        boolean flag;
        if (!this.altarMade && (flag = this.isWorldOriginTicking())) {
            ((Feature)WBFeatures.WB_PORTAL_ALTAR.get()).func_241855_a((ISeedReader)this.world, this.world.func_72863_F().func_201711_g(), this.world.field_73012_v, new BlockPos(0, 255, 0), (IFeatureConfig)IFeatureConfig.field_202429_e);
            this.altarMade = true;
            this.saveWBAltarData((World)this.world);
        }
    }

    private boolean isWorldOriginTicking() {
        for (int x = -1; x <= 0; ++x) {
            for (int z = -1; z <= 0; ++z) {
                IChunk ichunk = this.world.func_217353_a(x, z, ChunkStatus.field_222617_m, false);
                if (!(ichunk instanceof Chunk)) {
                    return false;
                }
                ChunkHolder.LocationType chunkholder$locationtype = ((Chunk)ichunk).func_217321_u();
                if (chunkholder$locationtype.func_219065_a(ChunkHolder.LocationType.TICKING)) continue;
                return false;
            }
        }
        return true;
    }

    public void saveWBAltarData(World world) {
        WBWorldSavedData.get(world).setWBAltarState(this.altarMade);
        WBWorldSavedData.get(world).func_76185_a();
    }
}

